/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class FileMisc {
    private static final int OWNER_READ_FILEMODE = 256;
    private static final int OWNER_WRITE_FILEMODE = 128;
    private static final int OWNER_EXEC_FILEMODE = 64;
    private static final int GROUP_READ_FILEMODE = 32;
    private static final int GROUP_WRITE_FILEMODE = 16;
    private static final int GROUP_EXEC_FILEMODE = 8;
    private static final int OTHERS_READ_FILEMODE = 4;
    private static final int OTHERS_WRITE_FILEMODE = 2;
    private static final int OTHERS_EXEC_FILEMODE = 1;

    public static String toUnixNewline(String input) {
        return input.replace("\r\n", "\n");
    }

    public static void copyFile(File srcFile, File dstFile, String ... toReplace) throws IOException {
        Preconditions.checkArgument((toReplace.length % 2 == 0 ? 1 : 0) != 0);
        HashMap replaceMap = Maps.newHashMap();
        for (int i = 0; i < toReplace.length / 2; ++i) {
            replaceMap.put(toReplace[2 * i], toReplace[2 * i + 1]);
        }
        String content = Joiner.on((String)"\n").join((Iterable)Files.readLines((File)srcFile, (Charset)StandardCharsets.UTF_8));
        for (Map.Entry entry : replaceMap.entrySet()) {
            content = content.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        dstFile.getParentFile().mkdirs();
        Files.write((byte[])content.getBytes(StandardCharsets.UTF_8), (File)dstFile);
    }

    public static void cleanDir(File dirToRemove) throws IOException {
        if (dirToRemove.isFile()) {
            dirToRemove.delete();
        } else if (dirToRemove.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)dirToRemove);
            }
            catch (IOException e) {
                for (File file : dirToRemove.listFiles()) {
                    if (file.isFile()) {
                        file.delete();
                        continue;
                    }
                    FileUtils.deleteDirectory((File)file);
                }
            }
        }
        dirToRemove.mkdirs();
    }

    public static void flatten(File dirToRemove) throws IOException {
        File parent = dirToRemove.getParentFile();
        for (File child : dirToRemove.listFiles()) {
            boolean createDestDir = false;
            if (child.isFile()) {
                FileUtils.moveFileToDirectory((File)child, (File)parent, (boolean)createDestDir);
                continue;
            }
            if (child.isDirectory()) {
                FileUtils.moveDirectoryToDirectory((File)child, (File)parent, (boolean)createDestDir);
                continue;
            }
            throw new IllegalArgumentException("Unknown filetype: " + child);
        }
        dirToRemove.delete();
    }

    public static void concat(Iterable<File> toMerge, File dst) throws IOException {
        try (FileChannel dstChannel = FileChannel.open(dst.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            for (File file : toMerge) {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                Throwable throwable = null;
                try {
                    FileChannel channel = raf.getChannel();
                    dstChannel.write(channel.map(FileChannel.MapMode.READ_ONLY, 0L, raf.length()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (raf == null) continue;
                    if (throwable != null) {
                        try {
                            raf.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    raf.close();
                }
            }
        }
    }

    public static int toOctalFileModeInt(Set<PosixFilePermission> permissions) {
        int result = 0;
        for (PosixFilePermission permissionBit : permissions) {
            switch (permissionBit) {
                case OWNER_READ: {
                    result |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    result |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    result |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    result |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    result |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    result |= 8;
                    break;
                }
                case OTHERS_READ: {
                    result |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    result |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    result |= 1;
                }
            }
        }
        return result;
    }

    public static String toOctalFileMode(Set<PosixFilePermission> permissions) {
        int value = FileMisc.toOctalFileModeInt(permissions);
        return Integer.toOctalString(value);
    }

    public static boolean containsExecutablePermission(Set<PosixFilePermission> permissions) {
        return permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) && permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) && permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
    }
}

