/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.TreeDef;
import com.google.common.collect.ImmutableList;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public abstract class ProjectPlugin
implements Plugin<Project> {
    public final void apply(Project project) {
        if (project.getPlugins().hasPlugin(this.getClass())) {
            return;
        }
        this.applyOnce(project);
    }

    protected abstract void applyOnce(Project var1);

    public static <T extends Plugin<?>> T getPlugin(Project project, Class<T> pluginClazz) {
        if (project.getPlugins().hasPlugin(pluginClazz)) {
            return (T)project.getPlugins().getPlugin(pluginClazz);
        }
        return (T)project.getPlugins().apply(pluginClazz);
    }

    public static TreeDef.Parented<Project> treeDef() {
        return TreeDef.Parented.of(p -> ImmutableList.copyOf(p.getChildProjects().values()), Project::getParent);
    }
}

