/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.base.Throwing;
import com.diffplug.gradle.FileMisc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void read(File input, String toRead, Throwing.Specific.Consumer<InputStream, IOException> reader) throws IOException {
        try (ZipFile file = new ZipFile(input);
             InputStream stream = file.getInputStream(file.getEntry(toRead));){
            reader.accept((Object)stream);
        }
    }

    public static String read(File input, String toRead) throws IOException {
        String raw = StringPrinter.buildString((Consumer)Errors.rethrow().wrap(printer -> ZipUtil.read(input, toRead, (Throwing.Specific.Consumer<InputStream, IOException>)((Throwing.Specific.Consumer)inputStream -> ZipUtil.copy(inputStream, printer.toOutputStream(StandardCharsets.UTF_8))))));
        return FileMisc.toUnixNewline(raw);
    }

    public static void modify(InputStream input, OutputStream output, Map<String, InputStream> toModify, Set<String> toOmit) throws IOException {
        ZipEntry entry;
        ZipInputStream zipInput = new ZipInputStream(input);
        ZipOutputStream zipOutput = new ZipOutputStream(output);
        while ((entry = zipInput.getNextEntry()) != null) {
            ZipEntry newEntry;
            InputStream replacement = toModify.get(entry.getName());
            if (replacement != null) {
                newEntry = new ZipEntry(entry.getName());
                newEntry.setComment(entry.getComment());
                newEntry.setExtra(entry.getExtra());
                newEntry.setMethod(entry.getMethod());
                newEntry.setTime(entry.getTime());
                zipOutput.putNextEntry(newEntry);
                ZipUtil.copy(replacement, zipOutput);
                replacement.close();
            } else if (!toOmit.contains(entry.getName())) {
                newEntry = new ZipEntry(entry);
                newEntry.setCompressedSize(-1L);
                zipOutput.putNextEntry(newEntry);
                ZipUtil.copy(zipInput, zipOutput);
            }
            zipInput.closeEntry();
            zipOutput.closeEntry();
        }
        zipInput.close();
        zipOutput.close();
    }

    public static void zip(File input, String pathWithinArchive, File output) throws IOException {
        try (ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output)));){
            zipStream.setMethod(8);
            zipStream.setLevel(9);
            zipStream.putNextEntry(new ZipEntry(pathWithinArchive));
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(input));){
                ZipUtil.copy(inputStream, zipStream);
            }
        }
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[1024];
        int numRead = input.read(buf);
        while (numRead > 0) {
            output.write(buf, 0, numRead);
            numRead = input.read(buf);
        }
    }
}

