/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.osgi;

import aQute.bnd.osgi.Builder;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Throwing;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.osgi.BndManifestExtension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;

public class BndManifestPlugin
extends ProjectPlugin {
    @Override
    protected void applyOnce(Project proj) {
        BndManifestExtension extension = (BndManifestExtension)proj.getExtensions().create("osgiBndManifest", BndManifestExtension.class, new Object[0]);
        proj.afterEvaluate(project2 -> {
            Optional<File> copyTo = Optional.ofNullable(bndManifestExtension.copyTo).map(arg_0 -> ((Project)proj).file(arg_0));
            ProjectPlugin.getPlugin(project2, JavaPlugin.class);
            Jar jarTask = (Jar)project2.getTasks().getByName("jar");
            jarTask.deleteAllActions();
            jarTask.getInputs().properties((Map)jarTask.getManifest().getEffectiveManifest().getAttributes());
            jarTask.getOutputs().file((Object)jarTask.getArchivePath());
            copyTo.ifPresent(arg_0 -> ((TaskOutputsInternal)jarTask.getOutputs()).file(arg_0));
            jarTask.doLast(unused -> {
                if (!bndManifestExtension.mergeWithExisting) {
                    JavaPluginConvention javaConvention = (JavaPluginConvention)project2.getConvention().getPlugin(JavaPluginConvention.class);
                    SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
                    Path currentManifest = main.getOutput().getResourcesDir().toPath().resolve("META-INF/MANIFEST.MF");
                    Errors.rethrow().run(() -> Files.deleteIfExists(currentManifest));
                }
                BndManifestPlugin.takeBndAction(project2, (Throwing.Consumer<aQute.bnd.osgi.Jar>)((Throwing.Consumer)jar2 -> {
                    BndManifestPlugin.createParents(jarTask.getArchivePath());
                    jar2.write(jarTask.getArchivePath());
                    if (copyTo.isPresent()) {
                        BndManifestPlugin.writeFile((File)copyTo.get(), (Throwing.Consumer<OutputStream>)((Throwing.Consumer)arg_0 -> ((aQute.bnd.osgi.Jar)jar2).writeManifest(arg_0)));
                    }
                }));
            });
        });
    }

    private static void writeFile(File file, Throwing.Consumer<OutputStream> writer) throws Throwable {
        BndManifestPlugin.createParents(file);
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            writer.accept((Object)output);
        }
    }

    private static void createParents(File file) {
        file.getParentFile().mkdirs();
    }

    private static void takeBndAction(Project project, Throwing.Consumer<aQute.bnd.osgi.Jar> onBuilder) {
        ProjectPlugin.getPlugin(project, JavaPlugin.class);
        Jar jarTask = (Jar)project.getTasks().getByName("jar");
        Errors.rethrow().run(() -> {
            try (Builder builder = new Builder();){
                builder.setBase(project.getProjectDir());
                Attributes attr = jarTask.getManifest().getEffectiveManifest().getAttributes();
                for (Map.Entry entry : attr.entrySet()) {
                    builder.set((String)entry.getKey(), entry.getValue().toString());
                }
                Set runtimeConfig = project.getConfigurations().getByName("runtime").getFiles();
                builder.addClasspath((Collection)runtimeConfig);
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
                builder.set("-includeresource", main.getOutput().getClassesDir() + "," + main.getOutput().getResourcesDir());
                if (builder.getBundleVersion() == null) {
                    try {
                        String version = project.getVersion().toString().replace("-SNAPSHOT", ".SNAPSHOT");
                        builder.setBundleVersion(version);
                    }
                    catch (Exception e) {
                        project.getLogger().warn(e.getMessage() + "  Must be 'major.minor.micro.qualifier'");
                        builder.setBundleVersion("0.0.0.ERRORSETVERSION");
                    }
                }
                onBuilder.accept((Object)builder.build());
            }
        });
    }
}

