/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.swt;

import com.diffplug.common.base.Unhandled;
import com.diffplug.common.swt.os.SwtPlatform;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NativeDepsExtension {
    public String version = "4.4.2";
    static final String NAME = "swtNativeDeps";
    static final String LUNA_SR2 = "4.4.2";
    static final String MARS_SR2 = "4.5.2";
    static final String SWT = "org.eclipse.swt";
    static final String SWT_PLATFORM = "org.eclipse.swt.${platform}";
    static final String JFACE = "org.eclipse.jface";
    static final String CORE_COMMANDS = "org.eclipse.core.commands";
    static final String EQUINOX_COMMON = "org.eclipse.equinox.common";
    static final List<String> DEPS = Collections.unmodifiableList(Arrays.asList("org.eclipse.swt", "org.eclipse.swt.${platform}", "org.eclipse.jface", "org.eclipse.core.commands", "org.eclipse.equinox.common"));

    public void version(String version) {
        this.version = version;
    }

    String updateSite() {
        String UPDATE_ROOT = "http://download.eclipse.org/eclipse/updates/";
        switch (this.version) {
            case "4.4.2": {
                return UPDATE_ROOT + "4.4/R-4.4.2-201502041700/";
            }
            case "4.5.2": {
                return UPDATE_ROOT + "4.5/R-4.5.2-201602121500/";
            }
        }
        throw Unhandled.stringException((String)this.version);
    }

    String versionForType(String type) {
        switch (this.version) {
            case "4.4.2": {
                switch (type) {
                    case "org.eclipse.jface": {
                        return "3.10.2.v20141021-1035";
                    }
                    case "org.eclipse.swt": {
                        return "3.103.2.v20150203-1313";
                    }
                    case "org.eclipse.swt.${platform}": {
                        return "3.103.2.v20150203-1351";
                    }
                    case "org.eclipse.core.commands": {
                        return "3.6.100.v20140528-1422";
                    }
                    case "org.eclipse.equinox.common": {
                        return "3.6.200.v20130402-1505";
                    }
                }
                throw Unhandled.stringException((String)this.version);
            }
            case "4.5.2": {
                switch (type) {
                    case "org.eclipse.jface": {
                        return "3.11.1.v20160128-1644";
                    }
                    case "org.eclipse.swt": {
                        return "3.104.2.v20160212-1350";
                    }
                    case "org.eclipse.swt.${platform}": {
                        return "3.104.2.v20160212-1350";
                    }
                    case "org.eclipse.core.commands": {
                        return "3.7.0.v20150422-0725";
                    }
                    case "org.eclipse.equinox.common": {
                        return "3.7.0.v20150402-1709";
                    }
                }
                throw Unhandled.stringException((String)this.version);
            }
        }
        throw Unhandled.stringException((String)this.version);
    }

    String fullDep(String dep) {
        if (dep.equals(SWT_PLATFORM)) {
            return "p2:org.eclipse.swt." + SwtPlatform.getRunning() + ":" + this.versionForType(dep);
        }
        return "p2:" + dep + ":" + this.versionForType(dep);
    }
}

