/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.eclipse.EclipseProjectPlugin;
import com.google.common.collect.Iterables;
import groovy.util.Node;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ProjectDependency;

public class ProjectDepsPlugin
extends ProjectPlugin {
    @Override
    protected void applyOnce(Project project) {
        EclipseProjectPlugin.modifyEclipseProject(project, eclipseModel -> {
            Task prepareEclipse = project.task("prepareEclipse");
            prepareEclipse.doLast(task -> {
                Set referencedProjects = eclipseModel.getProject().getReferencedProjects();
                project.getConfigurations().stream().flatMap(config -> config.getDependencies().stream()).filter(dep -> dep instanceof ProjectDependency).forEach(dep -> referencedProjects.add(dep.getName()));
            });
            ((Task)Iterables.getOnlyElement((Iterable)project.getTasksByName("eclipseClasspath", false))).dependsOn(new Object[]{prepareEclipse});
            ((Task)Iterables.getOnlyElement((Iterable)project.getTasksByName("eclipseProject", false))).dependsOn(new Object[]{prepareEclipse});
            eclipseModel.getClasspath().getFile().getXmlTransformer().addAction(xmlProvider -> {
                Node classpathNode = xmlProvider.asNode();
                Iterator classpathEntries = classpathNode.children().iterator();
                while (classpathEntries.hasNext()) {
                    Node entry = (Node)classpathEntries.next();
                    String path = (String)entry.attributes().get("path");
                    if (path == null || !eclipseModel.getProject().getReferencedProjects().contains(path.substring(1))) continue;
                    classpathEntries.remove();
                }
                for (String projectDep : eclipseModel.getProject().getReferencedProjects()) {
                    Node entry = classpathNode.appendNode((Object)"classpathentry");
                    entry.attributes().put("combineaccessrules", "true");
                    entry.attributes().put("exported", "true");
                    entry.attributes().put("kind", "src");
                    entry.attributes().put("path", "/" + projectDep);
                }
            });
        });
    }
}

