/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.gradle.CmdLine;
import com.diffplug.gradle.pde.EclipseWuff;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class EclipsecTask
extends DefaultTask {
    private ListMultimap<String, String> args = ArrayListMultimap.create();

    public void addArg(String key, String value) {
        this.args.put((Object)key, (Object)value);
    }

    @TaskAction
    public void build() throws Exception {
        EclipseWuff eclipse = new EclipseWuff(this.getProject());
        StringBuilder builder = new StringBuilder();
        builder.append(EclipsecTask.quote(eclipse.getEclipseConsoleExecutable()));
        for (String key : this.args.keySet()) {
            builder.append(" -");
            builder.append(key);
            builder.append(" ");
            builder.append(Joiner.on((String)",").join((Iterable)this.args.get((Object)key)));
        }
        CmdLine.runCmd(builder.toString());
    }

    private static String quote(File file) {
        return "\"" + file.getAbsolutePath() + "\"";
    }
}

