/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.swt.os.OS;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.pde.EclipsecTask;
import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class P2DirectorModel {
    private Set<String> ius = Sets.newHashSet();
    private Set<String> repos = Sets.newLinkedHashSet();
    private Set<String> metadataRepo = Sets.newLinkedHashSet();
    private Set<String> artifactRepo = Sets.newLinkedHashSet();
    private static final String PROFILE = "ProfileDiffPlugP2";

    public P2DirectorModel copy() {
        P2DirectorModel copy = new P2DirectorModel();
        copy.ius.addAll(this.ius);
        copy.repos.addAll(this.repos);
        copy.metadataRepo.addAll(this.metadataRepo);
        copy.artifactRepo.addAll(this.artifactRepo);
        return copy;
    }

    public void addIU(String iu) {
        this.ius.add(iu);
    }

    public void addRepo(String repo) {
        this.repos.add(repo);
    }

    public void addMetadataRepo(String repo) {
        this.metadataRepo.add(repo);
    }

    public void addArtifactRepo(String repo) {
        this.artifactRepo.add(repo);
    }

    public Task taskFor(Project project, String taskName, OS os, Object dstDir) throws Exception {
        EclipsecTask task = (EclipsecTask)project.getTasks().create(taskName, EclipsecTask.class);
        task.addArg("nosplash", "");
        task.addArg("application", "org.eclipse.equinox.p2.director");
        this.repos.forEach(repo -> task.addArg("repository", (String)repo));
        this.metadataRepo.forEach(repo -> task.addArg("metadataRepository", (String)repo));
        this.artifactRepo.forEach(repo -> task.addArg("artifactRepository", (String)repo));
        this.ius.forEach(iu -> task.addArg("installIU", (String)iu));
        task.addArg("profile", PROFILE);
        task.addArg("profileProperties", "org.eclipse.update.install.features=true");
        SwtPlatform platform = SwtPlatform.fromOS((OS)os);
        task.addArg("p2.os", platform.getOs());
        task.addArg("p2.ws", platform.getWs());
        task.addArg("p2.arch", platform.getArch());
        task.addArg("roaming", "");
        task.addArg("destination", "file:" + project.file(dstDir).getAbsolutePath());
        return task;
    }
}

