/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Errors;
import groovy.util.Node;
import groovy.xml.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.gradle.api.Action;

public class ConfigMisc {
    public static Supplier<byte[]> xml(Supplier<Node> node) {
        return () -> {
            Node root = (Node)node.get();
            return XmlUtil.serialize((Node)root).getBytes(StandardCharsets.UTF_8);
        };
    }

    public static Supplier<byte[]> props(Action<Map<String, String>> mapPopulate) {
        return () -> {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            mapPopulate.execute(map);
            return ConfigMisc.props(map);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] props(Map<String, String> map) {
        Properties properties = new Properties();
        map.forEach((key, value) -> properties.put(key, value));
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            Errors.rethrow().run(() -> properties.store((OutputStream)output, ""));
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }
}

