/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipserunner;

import com.diffplug.common.base.Errors;
import com.diffplug.gradle.JavaExecable;
import com.diffplug.gradle.eclipserunner.EclipseRunner;
import com.diffplug.gradle.eclipserunner.JarFolderRunner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.process.JavaExecSpec;

public class JarFolderRunnerExternalJvm
implements EclipseRunner {
    final File rootDirectory;
    @Nullable
    final Project project;

    public JarFolderRunnerExternalJvm(File rootDirectory) {
        this(rootDirectory, null);
    }

    public JarFolderRunnerExternalJvm(File rootDirectory, @Nullable Project project) {
        this.rootDirectory = Objects.requireNonNull(rootDirectory);
        this.project = project;
    }

    @Override
    public void run(List<String> args) throws Exception {
        RunOutside outside = new RunOutside(this.rootDirectory, args);
        Errors.constrainTo(Exception.class).run(() -> {
            if (this.project == null) {
                JavaExecable.execWithoutGradle(outside, (Action<JavaExecSpec>)((Action)this::modifyClassPath));
            } else {
                JavaExecable.exec(this.project, outside, (Action<JavaExecSpec>)((Action)this::modifyClassPath));
            }
        });
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="FindBugs thinks that setClasspath() doesn't have a side effect, but it actually does.")
    private void modifyClassPath(JavaExecSpec execSpec) {
        FileCollection classpath = execSpec.getClasspath();
        execSpec.setClasspath(classpath.filter(file -> !file.getName().startsWith("org.osgi.core")));
    }

    private static class RunOutside
    implements JavaExecable {
        final File rootFolder;
        final List<String> args;

        public RunOutside(File rootFolder, List<String> args) {
            this.rootFolder = rootFolder;
            this.args = args;
        }

        public void run() throws Throwable {
            JarFolderRunner launcher = new JarFolderRunner(this.rootFolder);
            launcher.run(this.args);
        }
    }
}

