/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.common.base.Errors;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.oomph.OomphIdeExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class OomphIdePlugin
extends ProjectPlugin {
    static final String IDE = "ide";
    static final String IDE_SETUP_WORKSPACE = "ideSetupWorkspace";
    static final String IDE_SETUP_P2 = "ideSetupP2";
    static final String IDE_CLEAN = "ideClean";

    @Override
    protected void applyOnce(Project project) {
        OomphIdeExtension extension = (OomphIdeExtension)project.getExtensions().create("oomphIde", OomphIdeExtension.class, new Object[]{project});
        Task ideSetupP2 = project.getTasks().create(IDE_SETUP_P2);
        ideSetupP2.doFirst(unused -> Errors.rethrow().run(extension::ideSetupP2));
        Task ideSetupWorkspace = project.getTasks().create(IDE_SETUP_WORKSPACE);
        ideSetupWorkspace.doFirst(unused -> Errors.rethrow().run(extension::ideSetupWorkspace));
        ideSetupWorkspace.dependsOn(new Object[]{ideSetupP2});
        Task ide = project.getTasks().create(IDE);
        ide.doFirst(unused -> Errors.rethrow().run(extension::ide));
        project.afterEvaluate(p -> {
            extension.addDependency((Project)p);
            if (!extension.p2isClean()) {
                ide.dependsOn(new Object[]{ideSetupP2});
            }
            if (!extension.workspaceExists()) {
                ide.dependsOn(new Object[]{ideSetupWorkspace});
            }
        });
        Task ideClean = project.getTasks().create(IDE_CLEAN);
        ideClean.doFirst(unused -> extension.ideClean());
        ideSetupP2.mustRunAfter(new Object[]{ideClean});
        ideSetupWorkspace.mustRunAfter(new Object[]{ideClean});
    }
}

