/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.p2;

import com.diffplug.common.base.Consumers;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.GoomphCacheLocations;
import com.diffplug.gradle.eclipserunner.EclipseApp;
import com.diffplug.gradle.eclipserunner.EclipseRunner;
import com.diffplug.gradle.p2.P2AntRunner;
import com.diffplug.gradle.p2.P2BootstrapInstallation;
import com.diffplug.gradle.pde.EclipseRelease;
import groovy.util.Node;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;

public class P2Model
implements Serializable {
    private static final long serialVersionUID = 6458767795698285906L;
    private Set<String> ius = new LinkedHashSet<String>();
    private Set<String> repos = new LinkedHashSet<String>();
    private Set<String> metadataRepos = new LinkedHashSet<String>();
    private Set<String> artifactRepos = new LinkedHashSet<String>();
    private final List<Object> content = Arrays.asList(this.ius, this.repos, this.metadataRepos, this.artifactRepos);
    private static final String FEATURE_GROUP = ".feature.group";

    public P2Model copy() {
        P2Model copy = new P2Model();
        copy.copyFrom(this);
        return copy;
    }

    public void copyFrom(P2Model other) {
        this.ius.addAll(other.ius);
        this.repos.addAll(other.repos);
        this.metadataRepos.addAll(other.metadataRepos);
        this.artifactRepos.addAll(other.artifactRepos);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof P2Model) {
            return this.content.equals(((P2Model)otherObj).content);
        }
        return false;
    }

    public String toString() {
        return StringPrinter.buildString(printer -> {
            BiConsumer<String, Set> add = (name, set) -> {
                for (String element : set) {
                    printer.print(name);
                    printer.print(": ");
                    printer.print(element);
                    printer.println("");
                }
            };
            add.accept("repo", this.repos);
            add.accept("metadataRepo", this.metadataRepos);
            add.accept("artifactRepo", this.artifactRepos);
            add.accept("ius", this.ius);
        });
    }

    public void addIU(String iu) {
        this.ius.add(iu);
    }

    public void addIU(String iu, String version) {
        this.ius.add(iu + "/" + version);
    }

    public void addFeature(String feature) {
        this.addIU(feature + FEATURE_GROUP);
    }

    public void addFeature(String feature, String version) {
        this.addIU(feature + FEATURE_GROUP, version);
    }

    public Set<String> getRepos() {
        return this.repos;
    }

    public void addRepoEclipse(String release) {
        this.addRepo(EclipseRelease.official(release).updateSite());
    }

    public void addRepo(String repo) {
        this.repos.add(repo);
    }

    public void addRepo(File repo) {
        this.addRepo(FileMisc.asUrl(repo));
    }

    public void addMetadataRepo(String repo) {
        this.metadataRepos.add(repo);
    }

    public void addMetadataRepo(File repo) {
        this.addMetadataRepo(FileMisc.asUrl(repo));
    }

    public void addArtifactRepo(String repo) {
        this.artifactRepos.add(repo);
    }

    public void addArtifactRepo(File repo) {
        this.addArtifactRepo(FileMisc.asUrl(repo));
    }

    public void addArtifactRepoBundlePool() {
        this.addArtifactRepo(GoomphCacheLocations.bundlePool());
    }

    private boolean removeNonExistentLocal() {
        Predicate<String> nonExistentLocal = repo -> {
            if (!repo.startsWith("file://")) {
                return false;
            }
            File file = new File(repo.substring("file://".length()));
            if (!file.isDirectory()) {
                return true;
            }
            for (File child : FileMisc.list(file)) {
                if (!child.isFile() || !child.getName().startsWith("artifacts.") && !child.getName().startsWith("content.")) continue;
                return false;
            }
            return true;
        };
        boolean anyRemoved = false;
        anyRemoved |= this.repos.removeIf(nonExistentLocal);
        anyRemoved |= this.metadataRepos.removeIf(nonExistentLocal);
        return anyRemoved |= this.artifactRepos.removeIf(nonExistentLocal);
    }

    private <T> T performWithoutNonExistentLocalRepos(Supplier<T> supplier) {
        P2Model backup = this.copy();
        boolean needToRestore = this.removeNonExistentLocal();
        T result = supplier.get();
        if (needToRestore) {
            this.repos.addAll(backup.repos);
            this.metadataRepos.addAll(backup.metadataRepos);
            this.artifactRepos.addAll(backup.artifactRepos);
        }
        return result;
    }

    public P2AntRunner mirrorApp(File dstFolder) {
        return this.performWithoutNonExistentLocalRepos(() -> P2AntRunner.create("p2.mirror", (Action<Node>)((Action)taskNode -> {
            this.sourceNode((Node)taskNode);
            Node destination = new Node(taskNode, (Object)"destination");
            destination.attributes().put("location", FileMisc.asUrl(dstFolder));
            for (String iu : this.ius) {
                Node iuNode = new Node(taskNode, (Object)"iu");
                int slash = iu.indexOf(47);
                if (slash == -1) {
                    iuNode.attributes().put("id", iu);
                    continue;
                }
                iuNode.attributes().put("id", iu.substring(0, slash));
                iuNode.attributes().put("version", iu.substring(slash + 1));
            }
        })));
    }

    private Node sourceNode(Node parent) {
        Node source = new Node(parent, (Object)"source");
        BiConsumer<Iterable, Consumer> addRepos = (urls, repoAttributes) -> {
            for (String url : urls) {
                Node repository = source.appendNode((Object)"repository");
                repository.attributes().put("location", url);
                repoAttributes.accept(repository.attributes());
            }
        };
        addRepos.accept(this.repos, Consumers.doNothing());
        addRepos.accept(this.metadataRepos, repoAttr -> repoAttr.put("kind", "metadata"));
        addRepos.accept(this.artifactRepos, repoAttr -> repoAttr.put("kind", "artifact"));
        return source;
    }

    public DirectorApp directorApp(File dstFolder, String profile) {
        return this.performWithoutNonExistentLocalRepos(() -> {
            DirectorApp builder = new DirectorApp();
            builder.clean();
            builder.consolelog();
            this.repos.forEach(repo -> builder.addArg("repository", (String)repo));
            this.metadataRepos.forEach(repo -> builder.addArg("metadataRepository", (String)repo));
            this.artifactRepos.forEach(repo -> builder.addArg("artifactRepository", (String)repo));
            this.ius.forEach(iu -> builder.addArg("installIU", (String)iu));
            builder.addArg("profile", profile);
            builder.addArg("destination", FileMisc.asUrl(dstFolder));
            builder.doLast.add(() -> {
                Path path = dstFolder.toPath().resolve("p2/org.eclipse.equinox.p2.engine/.settings");
                FileUtils.deleteDirectory((File)path.toFile());
            });
            return builder;
        });
    }

    public static class DirectorApp
    extends EclipseApp {
        final List<Throwing.Runnable> doLast = new ArrayList<Throwing.Runnable>();

        public DirectorApp() {
            super("org.eclipse.equinox.p2.director");
        }

        public void bundlepool(File bundlePool) {
            this.addArg("bundlepool", bundlePool.getAbsolutePath());
        }

        public void platform(SwtPlatform platform) {
            String dest;
            this.addArg("p2.os", platform.getOs());
            this.addArg("p2.ws", platform.getWs());
            this.addArg("p2.arch", platform.getArch());
            if (platform.getOs().equals("macosx") && !(dest = (String)this.args.get((Object)"destination").get(0)).endsWith(".app")) {
                System.err.println("WARNING: Mac installs should end with '.app', this is " + dest);
            }
        }

        public void roaming() {
            this.addArg("roaming");
        }

        public void shared() {
            this.addArg("shared");
        }

        public void shared(File shared) {
            this.addArg("shared", shared.getAbsolutePath());
        }

        public void profileProperty(String key, String value) {
            this.addArg("profileProperties", FileMisc.noQuote(key) + "=" + FileMisc.noQuote(value));
        }

        public void installFeatures() {
            this.profileProperty("org.eclipse.update.install.features", "true");
        }

        public void runUsingBootstrapper() throws Exception {
            this.runUsing(P2BootstrapInstallation.latest().outsideJvmRunner());
        }

        public void runUsingBootstrapper(Project project) throws Exception {
            this.runUsing(P2BootstrapInstallation.latest().outsideJvmRunner(project));
        }

        @Override
        public void runUsing(EclipseRunner runner) throws Exception {
            super.runUsing(runner);
            for (Throwing.Runnable toRun : this.doLast) {
                Errors.constrainTo(Exception.class).run(toRun);
            }
        }
    }
}

