/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.base.StandardSystemProperty;
import com.diffplug.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class JdkConfig {
    private static final String KEY_JAVA = "org.gradle.java.home";
    public File rootFolder;
    public String name = "JavaSE-1.8";
    public String source = "1.8";
    public String target = "1.8";
    public List<String> jreLibs = ImmutableList.of((Object)"jre/lib/rt.jar", (Object)"jre/lib/jsse.jar", (Object)"jre/lib/jce.jar");

    public JdkConfig(Project project) {
        String javaHome = (String)project.property(KEY_JAVA);
        if (javaHome == null) {
            javaHome = StandardSystemProperty.JAVA_HOME.value();
        }
        Objects.requireNonNull(javaHome, "Could not find JRE dir, set 'org.gradle.java.home' to fix.");
        this.rootFolder = new File(javaHome);
    }

    public JdkConfig(File rootFile) {
        this.rootFolder = rootFile;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public List<File> getJdkLibs() {
        return this.jreLibs.stream().map(lib -> this.rootFolder.toPath().resolve((String)lib).toFile()).collect(Collectors.toList());
    }
}

