/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipserunner;

import com.diffplug.common.base.Unhandled;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;

public class EclipseIni {
    List<Line> lines = new ArrayList<Line>();
    private static final Line VM_ARGS = new Line(Dash.SINGLE, "vmargs");

    public static EclipseIni parseFrom(File file) throws FileNotFoundException, IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.ISO_8859_1));){
            String line;
            EclipseIni ini = new EclipseIni();
            while ((line = reader.readLine()) != null) {
                ini.lines.add(Line.parse(line));
            }
            EclipseIni eclipseIni = ini;
            return eclipseIni;
        }
    }

    public void writeTo(File file) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.ISO_8859_1));){
            for (Line line : this.lines) {
                writer.println(line.toString());
            }
        }
    }

    public String getAfter(String input) {
        Line line = Line.parse(input);
        int i = this.lines.indexOf(line);
        Line result = this.lines.get(i + 1);
        Preconditions.checkState((result.dash == Dash.NONE ? 1 : 0) != 0, (String)"Expected no dashes, was %s", (Object[])new Object[]{result});
        return result.content;
    }

    public String[] getLinesAsArray() {
        return this.lines.stream().map(Line::toString).collect(Collectors.toList()).toArray(new String[this.lines.size()]);
    }

    public void set(String key, String value) {
        Line keyLine = Line.parse(key);
        int idx = this.lines.indexOf(keyLine);
        if (idx != -1) {
            this.lines.remove(idx);
            if (this.lines.size() > idx && this.lines.get((int)idx).dash == Dash.NONE) {
                this.lines.remove(idx);
            }
        } else {
            idx = this.lines.indexOf(VM_ARGS);
            if (idx == -1) {
                idx = this.lines.size();
            }
        }
        this.lines.add(idx, keyLine);
        this.lines.add(idx + 1, Line.parse(value));
    }

    public void set(String key, File file) {
        this.set(key, file.getAbsolutePath().replace('\\', '/'));
    }

    public void vmargs(String ... vmargs) {
        int idx = this.lines.indexOf(VM_ARGS);
        if (idx != -1) {
            this.lines = this.lines.subList(0, idx);
        }
        this.lines.add(VM_ARGS);
        for (String vmarg : vmargs) {
            this.lines.add(Line.parse(vmarg));
        }
    }

    private static class Line {
        final Dash dash;
        final String content;

        private Line(Dash dash, String content) {
            this.dash = dash;
            this.content = content;
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof Line) {
                Line other = (Line)otherObj;
                return this.dash == other.dash && this.content.equals(other.content);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.dash, this.content});
        }

        public String toString() {
            return this.dash.toString() + this.content;
        }

        static Line parse(String input) {
            Dash dash = Dash.parse(input);
            return new Line(dash, input.substring(dash.length()));
        }
    }

    private static enum Dash {
        DOUBLE,
        SINGLE,
        NONE;


        static Dash parse(String input) {
            if (input.startsWith("--")) {
                return DOUBLE;
            }
            if (input.startsWith("-")) {
                return SINGLE;
            }
            return NONE;
        }

        private <T> T doubleSingleNone(T dbl, T sgl, T none) {
            switch (this) {
                case DOUBLE: {
                    return dbl;
                }
                case SINGLE: {
                    return sgl;
                }
                case NONE: {
                    return none;
                }
            }
            throw Unhandled.enumException((Enum)this);
        }

        public int length() {
            return this.doubleSingleNone(2, 1, 0);
        }

        public String toString() {
            return this.doubleSingleNone("--", "-", "");
        }
    }
}

