/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Box;
import com.diffplug.common.base.Errors;
import com.diffplug.common.swt.os.OS;
import com.diffplug.gradle.FileMisc;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.gradle.testfixtures.ProjectBuilder;
import org.gradle.util.CollectionUtils;

public class JavaExecWinFriendly {
    public static final String LONG_CLASSPATH_JAR_PREFIX = "long-classpath";
    private static final String MATCH_CHUNKS_OF_70_CHARACTERS = "(?<=\\G.{70})";

    private JavaExecWinFriendly() {
    }

    public static ExecResult javaExec(Project project, Action<JavaExecSpec> spec) throws IOException {
        if (OS.getNative().isWindows()) {
            Box.Nullable classpathJarBox = Box.Nullable.ofNull();
            ExecResult execResult = project.javaexec(execSpec -> {
                spec.execute(execSpec);
                File classpathJar = JavaExecWinFriendly.toJarWithClasspath((Iterable<File>)execSpec.getClasspath());
                classpathJar.deleteOnExit();
                execSpec.setClasspath((FileCollection)project.files(new Object[]{classpathJar}));
                classpathJarBox.set((Object)classpathJar);
            });
            Errors.suppress().run(() -> FileMisc.forceDelete((File)classpathJarBox.get()));
            return execResult;
        }
        return project.javaexec(spec);
    }

    public static ExecResult javaExecWithoutGradle(Action<JavaExecSpec> spec) throws IOException {
        Project project = ProjectBuilder.builder().build();
        return JavaExecWinFriendly.javaExec(project, spec);
    }

    private static File toJarWithClasspath(Iterable<File> files) {
        return (File)Errors.rethrow().get(() -> {
            File jarFile = File.createTempFile(LONG_CLASSPATH_JAR_PREFIX, ".jar");
            try (ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));){
                zip.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                try (PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)zip, StandardCharsets.UTF_8)));){
                    pw.println("Manifest-Version: 1.0");
                    String classPath = CollectionUtils.join((String)" ", (Iterable)CollectionUtils.collect((Iterable)files, File::toURI));
                    String classPathEntry = "Class-Path: " + classPath;
                    pw.println(CollectionUtils.join((String)"\n ", (Object[])classPathEntry.split(MATCH_CHUNKS_OF_70_CHARACTERS)));
                }
            }
            return jarFile;
        });
    }
}

