/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.gradle.OrderingConstraints;
import com.diffplug.gradle.oomph.OomphConvention;
import com.diffplug.gradle.oomph.OomphIdeExtension;
import com.diffplug.gradle.oomph.ProjectImporter;
import com.diffplug.gradle.oomph.SetupAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Action;

public class ConventionPde
extends OomphConvention {
    ConventionPde(OomphIdeExtension extension) {
        super(extension);
        this.requireIUs("org.eclipse.platform.ide", "org.eclipse.jdt.feature.group", "org.eclipse.pde.feature.group");
        this.setPerspectiveOver("org.eclipse.pde.ui.PDEPerspective", "org.eclipse.jdt.ui.JavaPerspective", "org.eclipse.ui.resourcePerspective");
    }

    public void targetplatform(Action<TargetPlatform> targetplatform) {
        this.targetplatform("targetplatform", targetplatform);
    }

    public void targetplatform(String name, Action<TargetPlatform> targetplatform) {
        this.extension.addSetupActionLazy((Action<List<SetupAction>>)((Action)actions -> {
            TargetPlatform instance = new TargetPlatform();
            targetplatform.execute((Object)instance);
            actions.add(new TargetPlatformSetter(name, instance.installations));
        }));
    }

    public static class TargetPlatformSetter
    extends SetupAction {
        private static final long serialVersionUID = 3285583309500818867L;
        String name;
        ArrayList<File> installations;

        public TargetPlatformSetter(String name, ArrayList<File> installations) {
            super("com.diffplug.gradle.oomph.ConventionPdeTargetPlatformSetter");
            this.name = Objects.requireNonNull(name);
            this.installations = Objects.requireNonNull(installations);
        }

        @Override
        protected void populateOrdering(OrderingConstraints<Class<? extends SetupAction>> ordering) {
            ordering.before(ProjectImporter.class);
        }

        @Override
        public String getDescription() {
            return "create targetplatform";
        }
    }

    public class TargetPlatform {
        ArrayList<File> installations = new ArrayList();

        public void installation(Object installation) {
            this.installations.add(ConventionPde.this.extension.project.file(installation));
        }
    }
}

