/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Throwing;
import com.diffplug.common.tree.TreeStream;
import com.diffplug.gradle.JavaExecWinFriendly;
import com.diffplug.gradle.JavaExecableImp;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.SerializableMisc;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

public interface JavaExecable
extends Serializable,
Throwing.Runnable {
    public static final String BUILDSCRIPT_CLASSPATH = "classpath";

    public static <T extends JavaExecable> T exec(Project project, T input, Action<JavaExecSpec> settings) throws Throwable {
        List classpaths = TreeStream.toParent(ProjectPlugin.treeDef(), (Object)project).map(p -> p.getBuildscript().getConfigurations().getByName(BUILDSCRIPT_CLASSPATH)).collect(Collectors.toList());
        classpaths.add(project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().gradleApi()}));
        classpaths.add(JavaExecableImp.fromLocalClassloader());
        UnionFileCollection classpath = new UnionFileCollection(classpaths);
        return JavaExecableImp.execInternal(input, (FileCollection)classpath, settings, (Throwing.Function<Action<JavaExecSpec>, ExecResult>)((Throwing.Function)execSpec -> JavaExecWinFriendly.javaExec(project, (Action<JavaExecSpec>)execSpec)));
    }

    public static <T extends JavaExecable> T exec(Project project, T input) throws Throwable {
        return JavaExecable.exec(project, input, (Action<JavaExecSpec>)((Action)unused -> {}));
    }

    public static <T extends JavaExecable> T execWithoutGradle(T input, Action<JavaExecSpec> settings) throws Throwable {
        FileCollection classpath = JavaExecableImp.fromLocalClassloader();
        return JavaExecableImp.execInternal(input, classpath, settings, (Throwing.Function<Action<JavaExecSpec>, ExecResult>)((Throwing.Function)execSpec -> JavaExecWinFriendly.javaExecWithoutGradle((Action<JavaExecSpec>)execSpec)));
    }

    public static <T extends JavaExecable> T execWithoutGradle(T input) throws Throwable {
        return JavaExecable.execWithoutGradle(input, (Action<JavaExecSpec>)((Action)unused -> {}));
    }

    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        try {
            JavaExecable javaExecOutside = (JavaExecable)SerializableMisc.read(file);
            javaExecOutside.run();
            SerializableMisc.write(file, javaExecOutside);
        }
        catch (Throwable t) {
            SerializableMisc.writeThrowable(file, t);
        }
    }

    public static enum Mode {
        INTERNAL,
        EXTERNAL;

    }
}

