/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.p2;

import com.diffplug.common.base.Errors;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.p2.AsMavenGroup;
import com.diffplug.gradle.p2.AsMavenGroupImpl;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;

public class AsMavenExtension {
    public static final String NAME = "p2AsMaven";
    Object destination = "build/p2asmaven";
    final LinkedHashMap<String, Action<AsMavenGroup>> groups = new LinkedHashMap();

    public void destination(Object destination) {
        this.destination = Objects.requireNonNull(destination);
    }

    public void group(String mavenGroup, Action<AsMavenGroup> action) {
        Action<AsMavenGroup> previous = this.groups.put(mavenGroup, action);
        if (previous != null) {
            throw new IllegalArgumentException("Duplicate groups for " + mavenGroup);
        }
    }

    void run(Project project) {
        HashSet<File> files = new HashSet<File>();
        File p2asmaven = project.file(this.destination);
        this.groups.forEach((group, action) -> {
            AsMavenGroup def = new AsMavenGroup((String)group);
            action.execute((Object)def);
            AsMavenGroupImpl impl = (AsMavenGroupImpl)Errors.rethrow().get(() -> def.run(project, p2asmaven));
            files.add(impl.dirP2());
            files.add(impl.dirP2Runnable());
            files.add(impl.dirMavenGroup());
            files.add(impl.tokenFile());
        });
        this.deleteStragglers(p2asmaven, files, "p2", "p2runnable", "maven");
    }

    private void deleteStragglers(File root, Set<File> toKeep, String ... dirs) {
        for (String dir : dirs) {
            File dirRoot = new File(root, dir);
            if (!dirRoot.exists()) continue;
            for (File file : FileMisc.list(dirRoot)) {
                if (toKeep.contains(file)) continue;
                Errors.log().run(() -> FileMisc.forceDelete(file));
            }
        }
    }

    File mavenDir(Project project) {
        return new File(project.file(this.destination), "maven");
    }
}

