/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.p2;

import com.diffplug.common.collect.HashMultimap;
import com.diffplug.common.collect.Multimap;
import com.diffplug.gradle.FileMisc;
import groovy.util.Node;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.osgi.framework.Version;

class MavenRepoBuilder
implements AutoCloseable {
    final File root;
    final Multimap<Coordinate, Artifact> artifactMap = HashMultimap.create();

    MavenRepoBuilder(File root) throws Exception {
        this.root = Objects.requireNonNull(root);
    }

    public void install(String group, File osgiJar) throws Exception {
        boolean isSource;
        String version;
        String symbolicName;
        try (JarFile jarFile = new JarFile(osgiJar);){
            if (jarFile.getManifest() != null) {
                Attributes attr = jarFile.getManifest().getMainAttributes();
                symbolicName = MavenRepoBuilder.beforeSemicolon(attr.getValue("Bundle-SymbolicName"));
                version = attr.getValue("Bundle-Version");
                String source = attr.getValue("Eclipse-SourceBundle");
                if (source != null) {
                    isSource = true;
                    symbolicName = MavenRepoBuilder.beforeSemicolon(source).trim();
                } else {
                    isSource = false;
                }
            } else {
                String name = osgiJar.getName();
                int lastUnderscore = name.lastIndexOf("_");
                symbolicName = name.substring(0, lastUnderscore).trim();
                version = name.substring(lastUnderscore + 1);
                isSource = false;
                System.err.println(osgiJar.getAbsolutePath() + " has no manifest.  Guessing name=" + symbolicName + " and version=" + version);
            }
        }
        catch (RuntimeException e) {
            System.err.println("Error parsing manifest of " + osgiJar.getAbsolutePath() + ", unable to put this jar into maven.");
            return;
        }
        this.artifactMap.put((Object)new Coordinate(group, symbolicName), (Object)new Artifact(Version.parseVersion((String)version), isSource, osgiJar));
    }

    private static String beforeSemicolon(String input) {
        int firstSemiColon = input.indexOf(59);
        if (firstSemiColon == -1) {
            return input;
        }
        return input.substring(0, firstSemiColon);
    }

    @Override
    public void close() throws Exception {
        for (Coordinate coord : this.artifactMap.keySet()) {
            File groupFolder = new File(this.root, coord.group);
            File artifactFolder = new File(groupFolder, coord.artifactId);
            FileMisc.mkdirs(artifactFolder);
            Collection values = this.artifactMap.get((Object)coord);
            this.install(artifactFolder, coord, values);
        }
    }

    private void install(File artifactFolder, Coordinate coord, Collection<Artifact> artifacts) throws IOException {
        List allVersions = artifacts.stream().map(artifact -> artifact.version).distinct().sorted().collect(Collectors.toList());
        Node metadata = new Node(null, (Object)"metadata");
        new Node(metadata, (Object)"groupId").setValue((Object)coord.group);
        new Node(metadata, (Object)"artifactId").setValue((Object)coord.artifactId);
        new Node(metadata, (Object)"version").setValue(allVersions.get(allVersions.size() - 1));
        Node versioning = new Node(metadata, (Object)"versioning");
        Node versions = new Node(versioning, (Object)"versions");
        for (Version version : allVersions) {
            new Node(versions, (Object)"version").setValue((Object)version.toString());
        }
        new Node(versioning, (Object)"lastUpdated").setValue((Object)System.currentTimeMillis());
        String mavenMetadataContent = FileMisc.toUnixNewline(XmlUtil.serialize((Node)metadata));
        File mavenMetadata = new File(artifactFolder, "maven-metadata.xml");
        Files.write(mavenMetadata.toPath(), mavenMetadataContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        for (Artifact artifact2 : artifacts) {
            StringBuilder builder = new StringBuilder();
            builder.append(coord.artifactId);
            builder.append('-');
            builder.append(artifact2.version.toString());
            if (artifact2.isSources) {
                builder.append("-sources");
            }
            builder.append(".jar");
            File versionFolder = new File(artifactFolder, artifact2.version.toString());
            FileMisc.mkdirs(versionFolder);
            Files.copy(artifact2.jar.toPath(), new File(versionFolder, builder.toString()).toPath(), new CopyOption[0]);
        }
    }

    static class Artifact
    implements Comparable<Artifact> {
        final Version version;
        final boolean isSources;
        final File jar;
        static final Comparator<Artifact> comparator;

        public Artifact(Version version, boolean isSources, File jar) {
            this.version = Objects.requireNonNull(version);
            this.isSources = isSources;
            this.jar = Objects.requireNonNull(jar);
        }

        @Override
        public int compareTo(Artifact other) {
            return comparator.compare(this, other);
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof Artifact) {
                Artifact other = (Artifact)otherObj;
                return comparator.compare(this, other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.version, this.isSources);
        }

        static {
            Comparator<Artifact> byVersion = Comparator.comparing(artifact -> artifact.version);
            comparator = byVersion.thenComparing(artifact -> artifact.isSources ? 0 : 1);
        }
    }

    static class Coordinate {
        final String group;
        final String artifactId;

        public Coordinate(String group, String artifactId) {
            this.group = group;
            this.artifactId = artifactId;
        }

        public int hashCode() {
            return Objects.hash(this.group, this.artifactId);
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof Coordinate) {
                Coordinate other = (Coordinate)otherObj;
                return other.group.equals(this.group) && other.artifactId.equals(this.artifactId);
            }
            return false;
        }
    }
}

