/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.osgi;

import aQute.bnd.osgi.Builder;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Throwing;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.osgi.BndManifestExtension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;

public class BndManifestPlugin
extends ProjectPlugin {
    @Override
    protected void applyOnce(Project proj) {
        BndManifestExtension extension = (BndManifestExtension)proj.getExtensions().create("osgiBndManifest", BndManifestExtension.class, new Object[0]);
        proj.afterEvaluate(project -> {
            Optional<File> copyTo = Optional.ofNullable(extension.copyTo).map(arg_0 -> ((Project)proj).file(arg_0));
            ProjectPlugin.getPlugin(project, JavaPlugin.class);
            Jar jarTask = (Jar)project.getTasks().getByName("jar");
            jarTask.deleteAllActions();
            jarTask.getInputs().properties((Map)jarTask.getManifest().getEffectiveManifest().getAttributes());
            jarTask.getOutputs().file((Object)jarTask.getArchivePath());
            copyTo.ifPresent(arg_0 -> ((TaskOutputsInternal)jarTask.getOutputs()).file(arg_0));
            jarTask.doLast(Errors.rethrow().wrap(unused -> {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
                Path outputManifest = main.getOutput().getResourcesDir().toPath().resolve("META-INF/MANIFEST.MF");
                if (!extension.mergeWithExisting) {
                    Files.deleteIfExists(outputManifest);
                }
                BndManifestPlugin.takeBndAction(project, (Throwing.Consumer<aQute.bnd.osgi.Jar>)((Throwing.Consumer)jar -> {
                    BndManifestPlugin.createParents(jarTask.getArchivePath());
                    jar.write(jarTask.getArchivePath());
                    BndManifestPlugin.writeFile(outputManifest.toFile(), (Throwing.Consumer<OutputStream>)((Throwing.Consumer)arg_0 -> ((aQute.bnd.osgi.Jar)jar).writeManifest(arg_0)));
                    if (copyTo.isPresent()) {
                        BndManifestPlugin.writeFile((File)copyTo.get(), (Throwing.Consumer<OutputStream>)((Throwing.Consumer)arg_0 -> ((aQute.bnd.osgi.Jar)jar).writeManifest(arg_0)));
                    }
                }));
            })::accept);
        });
    }

    private static void writeFile(File file, Throwing.Consumer<OutputStream> writer) throws Throwable {
        BndManifestPlugin.createParents(file);
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            writer.accept((Object)output);
        }
    }

    private static void createParents(File file) {
        FileMisc.mkdirs(file.getParentFile());
    }

    private static void takeBndAction(Project project, Throwing.Consumer<aQute.bnd.osgi.Jar> onBuilder) {
        ProjectPlugin.getPlugin(project, JavaPlugin.class);
        Jar jarTask = (Jar)project.getTasks().getByName("jar");
        Errors.rethrow().run(() -> {
            try (Builder builder = new Builder();){
                builder.setBase(project.getProjectDir());
                Attributes attr = jarTask.getManifest().getEffectiveManifest().getAttributes();
                for (Map.Entry entry : attr.entrySet()) {
                    builder.set((String)entry.getKey(), entry.getValue().toString());
                }
                Set runtimeConfig = project.getConfigurations().getByName("runtime").getFiles();
                builder.addClasspath((Collection)runtimeConfig);
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                SourceSetOutput main = ((SourceSet)javaConvention.getSourceSets().getByName("main")).getOutput();
                BndManifestPlugin.deleteEmptyFoldersIfExists(main.getClassesDir());
                BndManifestPlugin.deleteEmptyFoldersIfExists(main.getResourcesDir());
                builder.set("-includeresource", main.getClassesDir() + "," + main.getResourcesDir());
                if (builder.getBundleVersion() == null) {
                    try {
                        String version = project.getVersion().toString();
                        if (version.endsWith("-SNAPSHOT")) {
                            version = version.replace("-SNAPSHOT", ".I" + BndManifestPlugin.dateQualifier());
                        }
                        builder.setBundleVersion(version);
                    }
                    catch (Exception e) {
                        project.getLogger().warn(e.getMessage() + "  Must be 'major.minor.micro.qualifier'");
                        builder.setBundleVersion("0.0.0.ERRORSETVERSION");
                    }
                }
                onBuilder.accept((Object)builder.build());
            }
        });
    }

    static void deleteEmptyFoldersIfExists(File root) throws IOException {
        if (root.exists()) {
            FileMisc.deleteEmptyFolders(root);
        }
    }

    static String dateQualifier() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddkkmm");
        return dateFormat.format(new Date());
    }
}

