/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipserunner;

import com.diffplug.common.base.Joiner;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.ImmutableMap;
import com.diffplug.common.collect.Iterables;
import com.diffplug.common.collect.SortedSetMultimap;
import com.diffplug.common.collect.TreeMultimap;
import com.diffplug.gradle.FileMisc;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class EquinoxLauncher {
    final File installationRoot;
    final SortedSetMultimap<String, Version> plugins = TreeMultimap.create();
    ImmutableList<String> args = ImmutableList.of();
    ImmutableMap<String, String> props = ImmutableMap.of();

    public EquinoxLauncher(File installationRoot) {
        this.installationRoot = Objects.requireNonNull(installationRoot);
        File pluginsDir = new File(installationRoot, "plugins");
        Preconditions.checkArgument((boolean)FileMisc.dirExists(pluginsDir), (String)"Eclipse launcher must have a plugins directory: %s", (Object[])new Object[]{installationRoot});
        block2: for (File file : FileMisc.list(pluginsDir)) {
            String fileName;
            if (!file.isFile() || !(fileName = file.getName()).endsWith(".jar")) continue;
            int verSplit = fileName.lastIndexOf(95);
            while (verSplit != -1) {
                try {
                    String name2 = fileName.substring(0, verSplit);
                    String version = fileName.substring(verSplit + 1, fileName.length() - ".jar".length());
                    this.plugins.put((Object)name2, (Object)Version.valueOf((String)version));
                    continue block2;
                }
                catch (IllegalArgumentException e) {
                    verSplit = fileName.lastIndexOf(95, verSplit - 1);
                }
            }
        }
        BiConsumer<String, String> requireBecause = (name, reason) -> Preconditions.checkArgument((boolean)this.plugins.containsKey(name), (String)"%s is required for %s", (Object[])new Object[]{name, reason});
        requireBecause.accept("org.eclipse.osgi", "running the OSGi platform");
        requireBecause.accept("org.eclipse.equinox.common", "bundle discovery and installation");
        requireBecause.accept("org.eclipse.update.configurator", "bundle discovery and installation");
        requireBecause.accept("org.eclipse.core.runtime", "eclipse application support");
        requireBecause.accept("org.eclipse.equinox.ds", "OSGi declarative services");
    }

    private File getPluginRequireSingle(String name) {
        SortedSet versions = this.plugins.get((Object)name);
        Preconditions.checkArgument((versions.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 version for %s, had %s", (Object[])new Object[]{name, versions});
        String version = ((Version)Iterables.getOnlyElement((Iterable)versions)).toString();
        return this.installationRoot.toPath().resolve("plugins/" + name + "_" + version + ".jar").toFile();
    }

    public EquinoxLauncher setArgs(List<String> args) {
        List filteredArgs = args.stream().filter(Objects::nonNull).filter(arg -> !arg.equals("--launcher.suppressErrors")).filter(arg -> !arg.equals("-nosplash")).collect(Collectors.toList());
        this.args = ImmutableList.copyOf(filteredArgs);
        return this;
    }

    public EquinoxLauncher setProps(Map<String, String> props) {
        this.props = ImmutableMap.copyOf(props);
        return this;
    }

    public Running open() throws Exception {
        return new Running((Map)this.props, (List)this.args);
    }

    public void run() throws Exception {
        try (Running running = this.open();){
            running.run();
        }
    }

    private Map<String, String> defaultSystemProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("osgi.framework.useSystemProperties", "false");
        map.put("osgi.install.area", this.installationRoot.getAbsolutePath());
        map.put("osgi.noShutdown", "false");
        map.put("equinox.use.ds", "true");
        map.put("osgi.bundles", Joiner.on((String)", ").join((Object)"org.eclipse.equinox.common@2:start", (Object)"org.eclipse.update.configurator@3:start", new Object[]{"org.eclipse.core.runtime@4:start", "org.eclipse.equinox.ds@5:start"}));
        map.put("osgi.framework", this.getPluginRequireSingle("org.eclipse.osgi").toURI().toString());
        return map;
    }

    private void modifyDefaultBy(Map<String, String> defaultMap, Map<String, String> modify) {
        modify.forEach((key, value) -> {
            if (value.isEmpty()) {
                defaultMap.remove(key);
            } else {
                defaultMap.put((String)key, (String)value);
            }
        });
    }

    public class Running
    implements AutoCloseable {
        final BundleContext bundleContext;

        private Running(Map<String, String> systemProps, List<String> args) throws Exception {
            Map defaults = EquinoxLauncher.this.defaultSystemProperties();
            EquinoxLauncher.this.modifyDefaultBy(defaults, systemProps);
            EclipseStarter.setInitialProperties((Map)defaults);
            this.bundleContext = EclipseStarter.startup((String[])args.toArray(new String[0]), null);
            Objects.requireNonNull(this.bundleContext);
        }

        public BundleContext bundleContext() {
            return this.bundleContext;
        }

        private void run() throws Exception {
            EclipseStarter.run(null);
            BundleContext bundleContext = EclipseStarter.getSystemBundleContext();
            EclipseStarter.shutdown();
            String result = bundleContext.getProperty("eclipse.exitcode");
            Preconditions.checkState((boolean)"0".equals(result), (String)"Unexpected return=0, was: %s", (Object[])new Object[]{result});
        }

        @Override
        public void close() throws Exception {
            EclipseStarter.shutdown();
        }
    }
}

