/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.base.Suppliers;
import com.diffplug.gradle.GroovyCompat;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.eclipse.EclipseProjectPlugin;
import groovy.util.Node;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.language.jvm.tasks.ProcessResources;

public class BuildPropertiesPlugin
extends ProjectPlugin {
    private Project project;
    private final Supplier<List<String>> binIncludes = Suppliers.memoize(() -> {
        File buildProperties = this.project.file((Object)"build.properties");
        if (!buildProperties.exists()) {
            throw new IllegalArgumentException("There is no 'build.properties' file - do not apply 'com.diffplug.gradle.eclipse.buildproperties' to this project");
        }
        Properties parsedProperties = new Properties();
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(buildProperties));){
            parsedProperties.load(stream);
        }
        catch (IOException e) {
            this.project.getLogger().warn(e.getMessage());
            return Collections.emptyList();
        }
        String raw = (String)parsedProperties.get("bin.includes");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(raw.split(",")));
        list.remove(".");
        return list;
    });

    @Override
    protected void applyOnce(Project project) {
        this.project = project;
        EclipseProjectPlugin.modifyEclipseProject(project, eclipseModel -> {
            eclipseModel.getClasspath().getFile().getXmlTransformer().addAction(xmlProvider -> {
                Node entry = xmlProvider.asNode().appendNode((Object)"classpathentry");
                entry.attributes().put("kind", "src");
                entry.attributes().put("path", "");
                String including = this.getBinIncludes().stream().collect(Collectors.joining("|"));
                entry.attributes().put("including", including);
            });
            ProjectPlugin.getPlugin(project, JavaPlugin.class);
            ProcessResources task = (ProcessResources)project.getTasks().getByName("processResources");
            task.from(new Object[]{project.getProjectDir()});
            for (String binInclude : this.getBinIncludes()) {
                if (binInclude.endsWith("/")) {
                    task.include(new String[]{binInclude + "**"});
                    continue;
                }
                task.include(new String[]{binInclude});
            }
            task.from((Object)"src", GroovyCompat.closureFrom((Object)task, spec -> spec.include(new String[]{"**"}).exclude(new String[]{"**/*.java"})));
        });
    }

    public static List<String> getBinIncludes(Project project) {
        BuildPropertiesPlugin plugin;
        try {
            plugin = (BuildPropertiesPlugin)project.getPlugins().getAt(BuildPropertiesPlugin.class);
        }
        catch (UnknownPluginException e) {
            plugin = (BuildPropertiesPlugin)project.getPlugins().apply(BuildPropertiesPlugin.class);
        }
        return plugin.getBinIncludes();
    }

    public List<String> getBinIncludes() {
        return this.binIncludes.get();
    }
}

