/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.osgi;

import aQute.bnd.osgi.Builder;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Predicates;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.collect.ImmutableMap;
import com.diffplug.common.io.FileWriteMode;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.ZipMisc;
import com.diffplug.gradle.osgi.BndManifestExtension;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.gradle.api.Project;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;

public class BndManifestPlugin
extends ProjectPlugin {
    @Override
    protected void applyOnce(Project proj) {
        ProjectPlugin.getPlugin(proj, JavaPlugin.class);
        BndManifestExtension extension = (BndManifestExtension)proj.getExtensions().create("osgiBndManifest", BndManifestExtension.class, new Object[0]);
        Jar jarTask = (Jar)proj.getTasks().getByName("jar");
        jarTask.doLast(unused -> Errors.rethrow().run(() -> {
            byte[] manifest = BndManifestPlugin.getManifestContent(jarTask, extension).getBytes(StandardCharsets.UTF_8);
            ImmutableMap toModify = ImmutableMap.of((Object)"META-INF/MANIFEST.MF", in -> manifest);
            ZipMisc.modify(jarTask.getArchivePath(), (Map<String, Function<byte[], byte[]>>)toModify, Predicates.alwaysFalse());
            if (extension.copyTo != null) {
                com.diffplug.common.io.Files.asByteSink((File)jarTask.getProject().file(extension.copyTo), (FileWriteMode[])new FileWriteMode[0]).write(manifest);
            }
        }));
        proj.afterEvaluate(project -> {
            if (extension.copyTo != null) {
                jarTask.getOutputs().file(extension.copyTo);
            }
        });
    }

    private static String getManifestContent(Jar jarTask, BndManifestExtension extension) throws Throwable {
        JavaPluginConvention javaConvention = (JavaPluginConvention)jarTask.getProject().getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
        Path outputManifest = main.getOutput().getResourcesDir().toPath().resolve("META-INF/MANIFEST.MF");
        if (!extension.mergeWithExisting) {
            Files.deleteIfExists(outputManifest);
        }
        return BndManifestPlugin.takeBndAction(jarTask.getProject(), jarTask, (Throwing.Function<aQute.bnd.osgi.Jar, String>)((Throwing.Function)jar -> StringPrinter.buildString(printer -> {
            try (OutputStream output = printer.toOutputStream(StandardCharsets.UTF_8);){
                aQute.bnd.osgi.Jar.writeManifest((Manifest)jar.getManifest(), (OutputStream)printer.toOutputStream(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                throw Errors.asRuntime((Throwable)e);
            }
        })));
    }

    private static String takeBndAction(Project project, Jar jarTask, Throwing.Function<aQute.bnd.osgi.Jar, String> onBuilder) throws Exception, Throwable {
        try (Builder builder = new Builder();){
            builder.setBase(project.getProjectDir());
            Attributes attr = jarTask.getManifest().getEffectiveManifest().getAttributes();
            for (Map.Entry entry : attr.entrySet()) {
                builder.set((String)entry.getKey(), entry.getValue().toString());
            }
            Set runtimeConfig = project.getConfigurations().getByName("runtimeClasspath").getFiles();
            builder.addClasspath((Collection)runtimeConfig);
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSetOutput main = ((SourceSet)javaConvention.getSourceSets().getByName("main")).getOutput();
            StringBuilder includeresource = new StringBuilder();
            BndManifestPlugin.deleteEmptyFoldersIfExists(main.getResourcesDir());
            includeresource.append(BndManifestPlugin.fix(main.getResourcesDir()));
            for (File file : main.getClassesDirs()) {
                BndManifestPlugin.deleteEmptyFoldersIfExists(file);
                includeresource.append(",");
                includeresource.append(BndManifestPlugin.fix(file));
            }
            builder.set("-includeresource", includeresource.toString());
            if (builder.getBundleVersion() == null) {
                try {
                    String version = project.getVersion().toString();
                    if (version.endsWith("-SNAPSHOT")) {
                        version = version.replace("-SNAPSHOT", ".I" + BndManifestPlugin.dateQualifier());
                    }
                    builder.setBundleVersion(version);
                }
                catch (Exception e) {
                    project.getLogger().warn(e.getMessage() + "  Must be 'major.minor.micro.qualifier'");
                    builder.setBundleVersion("0.0.0.ERRORSETVERSION");
                }
            }
            String string = (String)onBuilder.apply((Object)builder.build());
            return string;
        }
    }

    private static String fix(File file) {
        return file.getAbsolutePath().replace('\\', '/');
    }

    private static void deleteEmptyFoldersIfExists(File root) throws IOException {
        if (root.exists()) {
            FileMisc.deleteEmptyFolders(root);
        }
    }

    private static String dateQualifier() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddkkmm");
        return dateFormat.format(new Date());
    }
}

