/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.osgi;

import aQute.bnd.osgi.Builder;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Predicates;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.collect.ImmutableMap;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.ZipMisc;
import com.diffplug.gradle.osgi.BndManifestExtension;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;

public class BndManifestPlugin
extends ProjectPlugin {
    @Override
    protected void applyOnce(Project proj) {
        ProjectPlugin.getPlugin(proj, JavaPlugin.class);
        final BndManifestExtension extension = (BndManifestExtension)proj.getExtensions().create("osgiBndManifest", BndManifestExtension.class, new Object[0]);
        proj.afterEvaluate(project -> {
            Preconditions.checkArgument((extension.copyTo == null || extension.copyFromTask != null ? 1 : 0) != 0, (Object)"copyFromTask can not be null if copyTo is set. Please provide a source task.");
            final Jar copyFromTask = extension.copyFromTask == null ? null : BndManifestPlugin.getAsJar(proj, extension.copyFromTask);
            Preconditions.checkArgument((extension.copyFromTask == null || extension.includeTasks.contains(extension.copyFromTask) ? 1 : 0) != 0, (Object)"copyFromTask must reside within includeTask");
            extension.includeTasks.forEach(name -> {
                final Jar jarTask = BndManifestPlugin.getAsJar(proj, (String)name);
                jarTask.doLast("Set OSGi manifest", (Action)new Action<Task>(){

                    public void execute(Task unused) {
                        Errors.rethrow().run(() -> {
                            byte[] manifest = BndManifestPlugin.getManifestContent(jarTask, extension).getBytes(StandardCharsets.UTF_8);
                            ImmutableMap toModify = ImmutableMap.of((Object)"META-INF/MANIFEST.MF", in -> manifest);
                            ZipMisc.modify(((RegularFile)jarTask.getArchiveFile().get()).getAsFile(), (Map<String, Function<byte[], byte[]>>)toModify, Predicates.alwaysFalse());
                            Throwing.Consumer writeManifest = path -> {
                                if (Files.exists(path, new LinkOption[0]) && Arrays.equals(Files.readAllBytes(path), manifest)) {
                                    return;
                                }
                                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                                Files.write(path, manifest, new OpenOption[0]);
                            };
                            writeManifest.accept((Object)BndManifestPlugin.outputManifest(jarTask));
                            if (extension2.copyTo != null && jarTask.equals(copyFromTask)) {
                                writeManifest.accept((Object)jarTask.getProject().file(extension2.copyTo).toPath());
                            }
                        });
                    }
                });
            });
            if (extension.copyTo != null && copyFromTask != null) {
                copyFromTask.getOutputs().file(extension.copyTo);
            }
        });
    }

    private static Path outputManifest(Jar jarTask) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)jarTask.getProject().getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
        return main.getOutput().getResourcesDir().toPath().resolve("META-INF/MANIFEST.MF");
    }

    private static String getManifestContent(Jar jarTask, BndManifestExtension extension) throws Throwable {
        if (!extension.mergeWithExisting) {
            Files.deleteIfExists(BndManifestPlugin.outputManifest(jarTask));
        }
        return BndManifestPlugin.takeBndAction(jarTask.getProject(), jarTask, (Throwing.Function<aQute.bnd.osgi.Jar, String>)((Throwing.Function)jar -> StringPrinter.buildString(printer -> {
            try (OutputStream output = printer.toOutputStream(StandardCharsets.UTF_8);){
                aQute.bnd.osgi.Jar.writeManifest((Manifest)jar.getManifest(), (OutputStream)printer.toOutputStream(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                throw Errors.asRuntime((Throwable)e);
            }
        })));
    }

    private static String takeBndAction(Project project, Jar jarTask, Throwing.Function<aQute.bnd.osgi.Jar, String> onBuilder) throws Exception, Throwable {
        try (Builder builder = new Builder();){
            builder.setBase(project.getProjectDir());
            Attributes attr = jarTask.getManifest().getEffectiveManifest().getAttributes();
            for (Map.Entry entry : attr.entrySet()) {
                builder.set((String)entry.getKey(), entry.getValue().toString());
            }
            Set runtimeConfig = project.getConfigurations().getByName("runtimeClasspath").getFiles();
            builder.addClasspath((Collection)runtimeConfig);
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSetOutput main = ((SourceSet)javaConvention.getSourceSets().getByName("main")).getOutput();
            LinkedHashSet<String> includeresource = new LinkedHashSet<String>();
            BndManifestPlugin.deleteEmptyFoldersIfExists(main.getResourcesDir());
            includeresource.add(BndManifestPlugin.fix(main.getResourcesDir()));
            for (File file : main.getClassesDirs()) {
                BndManifestPlugin.deleteEmptyFoldersIfExists(file);
                includeresource.add(BndManifestPlugin.fix(file));
            }
            builder.set("-includeresource", String.join((CharSequence)",", includeresource));
            if (builder.getBundleVersion() == null) {
                try {
                    String version = project.getVersion().toString();
                    if (version.endsWith("-SNAPSHOT")) {
                        version = version.replace("-SNAPSHOT", ".I" + BndManifestPlugin.dateQualifier());
                    }
                    builder.setBundleVersion(version);
                }
                catch (Exception e) {
                    project.getLogger().warn(e.getMessage() + "  Must be 'major.minor.micro.qualifier'");
                    builder.setBundleVersion("0.0.0.ERRORSETVERSION");
                }
            }
            String string = (String)onBuilder.apply((Object)builder.build());
            return string;
        }
    }

    private static String fix(File file) {
        return file.getAbsolutePath().replace('\\', '/');
    }

    private static void deleteEmptyFoldersIfExists(File root) throws IOException {
        if (root.exists()) {
            FileMisc.deleteEmptyFolders(root);
        }
    }

    private static String dateQualifier() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddkkmm");
        return dateFormat.format(new Date());
    }

    private static Jar getAsJar(Project project, String taskName) {
        Task task = project.getTasks().getByName(taskName);
        Preconditions.checkArgument((boolean)(task instanceof Jar), (Object)("Task " + taskName + " must be a Jar derived task for generating BndManifest"));
        return (Jar)task;
    }
}

