/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.p2;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.collect.ImmutableSet;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.GoomphCacheLocations;
import com.diffplug.gradle.ZipMisc;
import com.diffplug.gradle.eclipserunner.EclipseRunner;
import com.diffplug.gradle.eclipserunner.JarFolderRunner;
import com.diffplug.gradle.eclipserunner.JarFolderRunnerExternalJvm;
import com.diffplug.gradle.p2.P2Model;
import com.diffplug.gradle.pde.EclipseRelease;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

class P2BootstrapInstallation {
    static final String DOWNLOAD_ROOT = "https://dl.bintray.com/diffplug/opensource/com/diffplug/gradle/goomph-p2-bootstrap/";
    static final String DOWNLOAD_FILE = "/goomph-p2-bootstrap.zip";
    static final ImmutableSet<EclipseRelease> SUPPORTED = ImmutableSet.of((Object)EclipseRelease.official("4.5.2"));
    final EclipseRelease release;
    static final String TOKEN = "installed";

    static P2BootstrapInstallation latest() {
        EclipseRelease latest = (EclipseRelease)SUPPORTED.asList().listIterator(SUPPORTED.size()).previous();
        return new P2BootstrapInstallation(latest);
    }

    P2BootstrapInstallation(EclipseRelease release) {
        this.release = Objects.requireNonNull(release);
        Preconditions.checkArgument((boolean)SUPPORTED.contains((Object)release), (String)"We only have bootstrap for ", (Object[])new Object[]{SUPPORTED});
    }

    File getRootFolder() {
        return new File(GoomphCacheLocations.p2bootstrap(), this.release.toString());
    }

    void ensureInstalled() throws IOException {
        if (!this.isInstalled()) {
            this.install();
        }
    }

    private boolean isInstalled() throws IOException {
        return FileMisc.hasToken(this.getRootFolder(), TOKEN);
    }

    private void install() throws IOException {
        System.out.print("Installing p2 bootstrap " + this.release + "... ");
        FileMisc.cleanDir(this.getRootFolder());
        File target = new File(this.getRootFolder(), DOWNLOAD_FILE);
        URL url = new URL(DOWNLOAD_ROOT + this.release.version() + DOWNLOAD_FILE);
        FileUtils.copyURLToFile((URL)url, (File)target);
        ZipMisc.unzip(target, target.getParentFile());
        FileMisc.forceDelete(target);
        FileMisc.writeToken(this.getRootFolder(), TOKEN);
        System.out.print("Success.");
    }

    P2Model p2model() {
        P2Model model = new P2Model();
        model.addRepo(this.release.updateSite());
        model.addFeature("org.eclipse.equinox.p2.core.feature");
        model.addIU("org.eclipse.equinox.p2.director.app");
        model.addIU("org.eclipse.equinox.p2.repository.tools");
        model.addIU("org.eclipse.core.net");
        model.addIU("org.eclipse.osgi.compatibility.state");
        model.addIU("org.eclipse.ant.core");
        model.addIU("org.apache.ant");
        model.addIU("org.eclipse.core.runtime");
        model.addIU("org.eclipse.update.configurator");
        model.addIU("org.eclipse.equinox.ds");
        return model;
    }

    public EclipseRunner withinJvmRunner() throws IOException {
        return args -> {
            this.ensureInstalled();
            new JarFolderRunner(this.getRootFolder()).run(args);
        };
    }

    public EclipseRunner outsideJvmRunner() throws IOException {
        return args -> {
            this.ensureInstalled();
            new JarFolderRunnerExternalJvm(this.getRootFolder()).run(args);
        };
    }

    public EclipseRunner outsideJvmRunner(Project project) throws IOException {
        return args -> {
            this.ensureInstalled();
            new JarFolderRunnerExternalJvm(this.getRootFolder(), project).run(args);
        };
    }
}

