/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.eclipse.MavenCentralMapping;
import com.diffplug.gradle.pde.EclipseRelease;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionSelector;

public class MavenCentralExtension {
    public static final String NAME = "eclipseMavenCentral";
    private final Project project;

    public MavenCentralExtension(Project project) {
        this.project = Objects.requireNonNull(project);
    }

    public void release(String version, Action<ReleaseConfigurer> configurer) throws IOException {
        this.release(EclipseRelease.official(version), configurer);
    }

    public void release(EclipseRelease release, Action<ReleaseConfigurer> configurer) throws IOException {
        configurer.execute((Object)new ReleaseConfigurer(release));
    }

    public class ReleaseConfigurer {
        final EclipseRelease release;
        final Map<String, String> bundleToVersion;
        private static final String $_OSGI_PLATFORM = "${osgi.platform}";

        public ReleaseConfigurer(EclipseRelease release) throws IOException {
            this.release = release;
            this.bundleToVersion = MavenCentralMapping.bundleToVersion(release);
        }

        public void compileOnly(String bundleId) {
            this.dep("compileOnly", bundleId);
        }

        public void testCompileOnly(String bundleId) {
            this.dep("testCompileOnly", bundleId);
        }

        @Deprecated
        public void compile(String bundleId) {
            this.dep("compile", bundleId);
        }

        public void api(String bundleId) {
            this.dep("api", bundleId);
        }

        public void implementation(String bundleId) {
            this.dep("implementation", bundleId);
        }

        @Deprecated
        public void testCompile(String bundleId) {
            this.dep("testCompile", bundleId);
        }

        public void testImplementation(String bundleId) {
            this.dep("testImplementation", bundleId);
        }

        @Deprecated
        public void runtime(String bundleId) {
            this.dep("runtime", bundleId);
        }

        public void runtimeOnly(String bundleId) {
            this.dep("runtimeOnly", bundleId);
        }

        @Deprecated
        public void testRuntime(String bundleId) {
            this.dep("testRuntime", bundleId);
        }

        public void testRuntimeOnly(String bundleId) {
            this.dep("testRuntimeOnly", bundleId);
        }

        public void dep(String configName, String bundleId) {
            String groupIdArtifactId = MavenCentralMapping.groupIdArtifactId(bundleId);
            MavenCentralExtension.this.project.getDependencies().add(configName, (Object)(groupIdArtifactId + ":" + this.bundleToVersion.get(bundleId)));
        }

        public void useNativesForRunningPlatform() {
            MavenCentralExtension.this.project.getConfigurations().all(config -> config.getResolutionStrategy().eachDependency(details -> {
                ModuleVersionSelector req = details.getRequested();
                if (req.getName().contains($_OSGI_PLATFORM)) {
                    String running = SwtPlatform.getRunning().toString();
                    details.useTarget((Object)(req.getGroup() + ":" + req.getName().replace($_OSGI_PLATFORM, running) + ":" + req.getVersion()));
                }
            }));
        }

        public void compileOnlyNative(String bundleId) {
            this.nativeDep("compileOnly", bundleId);
        }

        public void testCompileOnlyNative(String bundleId) {
            this.nativeDep("testCompileOnly", bundleId);
        }

        @Deprecated
        public void compileNative(String bundleId) {
            this.nativeDep("compile", bundleId);
        }

        public void apiNative(String bundleId) {
            this.nativeDep("api", bundleId);
        }

        public void implementationNative(String bundleId) {
            this.nativeDep("implementation", bundleId);
        }

        @Deprecated
        public void testCompileNative(String bundleId) {
            this.nativeDep("testCompile", bundleId);
        }

        public void testImplementationNative(String bundleId) {
            this.nativeDep("testImplementation", bundleId);
        }

        @Deprecated
        public void runtimeNative(String bundleId) {
            this.nativeDep("runtime", bundleId);
        }

        public void runtimeOnlyNative(String bundleId) {
            this.nativeDep("runtimeOnly", bundleId);
        }

        @Deprecated
        public void testRuntimeNative(String bundleId) {
            this.nativeDep("testRuntime", bundleId);
        }

        public void testRuntimeOnlyNative(String bundleId) {
            this.nativeDep("testRuntimeOnly", bundleId);
        }

        public void nativeDep(String configName, String bundleId) {
            SwtPlatform platform = SwtPlatform.getRunning();
            this.dep(configName, bundleId + "." + platform);
        }
    }
}

