/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.base.Box;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Throwing;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.GoomphCacheLocations;
import com.diffplug.gradle.ZipMisc;
import com.diffplug.gradle.pde.EclipseRelease;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MavenCentralMapping {
    private static final EclipseRelease FIRST_ON_CENTRAL = EclipseRelease.official("4.6.2");
    private static final String PLATFORM = "org.eclipse.platform";
    private static final String JDT = "org.eclipse.jdt";
    private static final String PDE = "org.eclipse.pde";
    private static final String ARTIFACTS_JAR = "artifacts.jar";

    public static String groupIdArtifactId(String bundleId) {
        if (bundleId.startsWith(JDT)) {
            return "org.eclipse.jdt:" + bundleId;
        }
        if (bundleId.startsWith(PDE)) {
            return "org.eclipse.pde:" + bundleId;
        }
        return "org.eclipse.platform:" + bundleId;
    }

    static Map<String, String> parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(inputStream);
        Node artifacts = doc.getDocumentElement().getElementsByTagName("artifacts").item(0);
        for (int i = 0; i < artifacts.getChildNodes().getLength(); ++i) {
            Node artifact = artifacts.getChildNodes().item(i);
            if (!"artifact".equals(artifact.getNodeName())) continue;
            String id = artifact.getAttributes().getNamedItem("id").getNodeValue();
            String version = artifact.getAttributes().getNamedItem("version").getNodeValue();
            Version parsed = Version.parseVersion((String)version);
            map.put(id, parsed.getMajor() + "." + parsed.getMinor() + "." + parsed.getMicro());
        }
        return map;
    }

    public static Map<String, String> bundleToVersion(EclipseRelease release) {
        if (release.version().compareTo(FIRST_ON_CENTRAL.version()) < 0) {
            System.err.println(FIRST_ON_CENTRAL.version() + " was the first eclipse release that was published on MavenCentral.");
        }
        File versionFolder = new File(GoomphCacheLocations.eclipseReleaseMetadata(), release.version().toString());
        FileMisc.mkdirs(versionFolder);
        File artifactsJar = new File(versionFolder, ARTIFACTS_JAR);
        if (artifactsJar.exists() && artifactsJar.length() > 0L) {
            try {
                return MavenCentralMapping.parseFromFile(artifactsJar);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Retrying download...");
                FileMisc.forceDelete(artifactsJar);
            }
        }
        return (Map)Errors.rethrow().get(() -> {
            FileMisc.download(release.updateSite() + ARTIFACTS_JAR, artifactsJar);
            return MavenCentralMapping.parseFromFile(artifactsJar);
        });
    }

    private static Map<String, String> parseFromFile(File artifactsJar) throws IOException {
        Box.Nullable value = Box.Nullable.ofNull();
        ZipMisc.read(artifactsJar, "artifacts.xml", (Throwing.Specific.Consumer<InputStream, IOException>)((Throwing.Specific.Consumer)input -> value.set(Errors.rethrow().get(() -> MavenCentralMapping.parse(input)))));
        return (Map)Objects.requireNonNull(value.get());
    }
}

