/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.base.Unhandled;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.JRE;
import com.diffplug.gradle.JavaExecable;
import com.diffplug.gradle.SerializableMisc;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.JavaExec;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

class JavaExecableImp {
    JavaExecableImp() {
    }

    static <T extends JavaExecable> T execInternal(T input, FileCollection classpath, Action<JavaExecSpec> settings, Throwing.Function<Action<JavaExecSpec>, ExecResult> javaExecer) throws Throwable {
        File tempFile = File.createTempFile("JavaExecOutside", ".temp");
        try {
            SerializableMisc.write(tempFile, input);
            ExecResult execResult = (ExecResult)javaExecer.apply(execSpec -> settings.execute((Object)((JavaExecSpec)execSpec.setMain(JavaExecable.class.getName()).args(new Object[]{tempFile.getAbsolutePath()}).setClasspath(classpath).jvmArgs(new Object[]{"-XX:+IgnoreUnrecognizedVMOptions", "--add-modules=ALL-SYSTEM", "--add-opens=java.base/jdk.internal.loader=ALL-UNNAMED"}))));
            execResult.rethrowFailure();
            Object result = SerializableMisc.read(tempFile);
            if (result instanceof JavaExecable) {
                JavaExecable javaExecable = (JavaExecable)result;
                return (T)javaExecable;
            }
            if (result instanceof Throwable) {
                throw (Throwable)result;
            }
            throw Unhandled.classException(result);
        }
        finally {
            FileMisc.forceDelete(tempFile);
        }
    }

    static Set<File> fromLocalClassloader() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        Consumer<Class> addPeerClasses = clazz -> {
            try {
                for (URL url : JRE.getClasspath(clazz.getClassLoader())) {
                    String name = url.getFile();
                    if (name == null) continue;
                    files.add(new File(name));
                }
            }
            catch (Exception e) {
                throw Errors.asRuntime((Throwable)e);
            }
        };
        addPeerClasses.accept(JavaExecable.class);
        addPeerClasses.accept(JavaExec.class);
        return files;
    }
}

