/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.StandardSystemProperty;
import com.diffplug.common.base.Unhandled;
import com.diffplug.common.primitives.Booleans;
import com.diffplug.common.swt.os.OS;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.ConfigMisc;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.GoomphCacheLocations;
import com.diffplug.gradle.JavaExecable;
import com.diffplug.gradle.Lazyable;
import com.diffplug.gradle.StateBuilder;
import com.diffplug.gradle.eclipserunner.EclipseIni;
import com.diffplug.gradle.eclipserunner.EclipseIniLauncher;
import com.diffplug.gradle.oomph.BrandingProductPlugin;
import com.diffplug.gradle.oomph.ConventionJdt;
import com.diffplug.gradle.oomph.ConventionPde;
import com.diffplug.gradle.oomph.ConventionStyle;
import com.diffplug.gradle.oomph.OomphConvention;
import com.diffplug.gradle.oomph.ProjectImporter;
import com.diffplug.gradle.oomph.SaveWorkspace;
import com.diffplug.gradle.oomph.SetupAction;
import com.diffplug.gradle.oomph.SetupWithinEclipse;
import com.diffplug.gradle.oomph.WorkspaceRegistry;
import com.diffplug.gradle.oomph.thirdparty.ConventionThirdParty;
import com.diffplug.gradle.p2.P2Declarative;
import com.diffplug.gradle.p2.P2Model;
import com.diffplug.gradle.pde.EclipseRelease;
import com.diffplug.gradle.pde.PdeInstallation;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.XmlProvider;
import org.gradle.api.file.FileCollection;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskReference;
import org.gradle.internal.Actions;
import org.gradle.plugins.ide.eclipse.GenerateEclipseProject;
import org.gradle.process.JavaExecSpec;

public class OomphIdeExtension
implements P2Declarative {
    public static final String NAME = "oomphIde";
    final Project project;
    final WorkspaceRegistry workspaceRegistry;
    final SortedSet<File> projectFiles = new TreeSet<File>();
    final Map<String, Object> workspaceFiles = new HashMap<String, Object>();
    final Map<String, Action<Map<String, String>>> workspaceProps = new HashMap<String, Action<Map<String, String>>>();
    final Map<String, Action<XmlProvider>> workspaceXmls = new HashMap<String, Action<XmlProvider>>();
    final P2Model p2 = new P2Model();
    final Lazyable<List<SetupAction>> setupActions = Lazyable.ofList();
    @Nonnull
    String name;
    @Nonnull
    String description;
    @Nonnull
    String perspective;
    @Nonnull
    Object ideDir = "build/oomph-ide" + FileMisc.macApp();
    @Nonnull
    Action<P2Model.DirectorApp> directorModifier = Actions.doNothing();
    @Nonnull
    Action<P2Model.DirectorApp> runP2Using;
    Action<EclipseIni> eclipseIni;
    Object icon;
    Object splash;
    private static final String DOT_PROJECT = ".project";
    static final String STALE_TOKEN = "token_stale";

    public OomphIdeExtension(Project project) throws IOException {
        this.project = Objects.requireNonNull(project);
        this.workspaceRegistry = WorkspaceRegistry.instance();
        this.description = this.name = project.getRootProject().getName();
        this.perspective = "org.eclipse.ui.resourcePerspective";
        this.runP2Using = app -> Errors.rethrow().run(() -> app.runUsingBootstrapper(project));
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public P2Model getP2() {
        return this.p2;
    }

    public void p2director(Action<P2Model.DirectorApp> directorModifier) {
        this.directorModifier = Objects.requireNonNull(directorModifier);
    }

    public void icon(Object icon) {
        this.icon = Objects.requireNonNull(icon);
    }

    public void splash(Object splash) {
        this.splash = Objects.requireNonNull(splash);
    }

    public void name(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public void description(String description) {
        this.description = Objects.requireNonNull(description);
    }

    public void perspective(String perspective) {
        this.perspective = Objects.requireNonNull(perspective);
    }

    public void eclipseIni(Action<EclipseIni> eclipseIni) {
        Preconditions.checkArgument((this.eclipseIni == null ? 1 : 0) != 0, (Object)"Can only set eclipseIni once");
        this.eclipseIni = eclipseIni;
    }

    public void ideDir(Object ideDir) {
        this.ideDir = Objects.requireNonNull(ideDir);
    }

    public void addAllProjects() {
        this.addAllProjects((Spec<String>)Specs.satisfyAll());
    }

    public void addAllProjects(Spec<String> include) {
        this.project.getRootProject().getAllprojects().forEach(p -> {
            if (p == this.project) {
                return;
            }
            if (include.isSatisfiedBy((Object)p.getPath())) {
                this.addDependency(this.project.evaluationDependsOn(p.getPath()));
            }
        });
    }

    public void findProjectsInIncludedBuilds(Spec<String> spec) {
        for (IncludedBuild included : this.project.getGradle().getIncludedBuilds()) {
            this.addProjectIfExists(included, included.getProjectDir(), spec);
            for (File sub : FileMisc.list(included.getProjectDir())) {
                if (!sub.isDirectory()) continue;
                this.addProjectIfExists(included, sub, spec);
            }
        }
    }

    public void findProjectsInIncludedBuilds() {
        this.findProjectsInIncludedBuilds((Spec<String>)Specs.satisfyAll());
    }

    private boolean addProjectIfExists(IncludedBuild included, File dir, Spec<String> spec) {
        File dotProject = new File(dir, DOT_PROJECT);
        String root = included.getProjectDir().getAbsolutePath();
        String sub = dir.getAbsolutePath();
        if (dotProject.isFile()) {
            Preconditions.checkArgument((boolean)sub.startsWith(root));
            String relative = sub.substring(root.length()).replace('/', ':').replace('\\', ':');
            if (spec.isSatisfiedBy((Object)relative)) {
                try {
                    TaskReference task = included.task(relative + ":eclipse");
                    this.ideSetup().dependsOn(new Object[]{task});
                    this.addProjectFolder(dir);
                    return true;
                }
                catch (UnknownTaskException unknownTaskException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public void addIncludedProject(String includedBuild, String projectPath) {
        IncludedBuild included = this.project.getGradle().includedBuild(includedBuild);
        File projectDir = new File(included.getProjectDir(), projectPath.substring(1).replace(':', '/'));
        Preconditions.checkArgument((boolean)this.addProjectIfExists(included, projectDir, (Spec<String>)Specs.satisfyAll()));
    }

    public void addProject(String projectPath) {
        this.addDependency(this.project.evaluationDependsOn(projectPath));
    }

    private Task ideSetup() {
        return this.project.getTasks().getByName("ideSetupWorkspace");
    }

    void addDependency(Project eclipseProject) {
        eclipseProject.getTasks().all(task -> {
            if ("eclipse".equals(task.getName())) {
                this.ideSetup().dependsOn(new Object[]{task});
            }
            if (task instanceof GenerateEclipseProject) {
                File projectFile = ((GenerateEclipseProject)task).getOutputFile();
                if (projectFile == null) {
                    this.project.getLogger().warn("eclipse task " + task + " has no project file");
                } else {
                    Preconditions.checkArgument((boolean)projectFile.getName().equals(DOT_PROJECT), (String)"Project file must be '.project', was %s", (Object[])new Object[]{projectFile});
                    this.projectFiles.add(projectFile);
                }
            }
        });
    }

    public void addProjectFolder(Object folderObj) {
        File folder = this.project.file(folderObj);
        Preconditions.checkArgument((boolean)folder.isDirectory(), (String)"Folder '%s' must be a directory containing a '%s' file.", (Object[])new Object[]{folder, DOT_PROJECT});
        this.projectFiles.add(new File(folder, DOT_PROJECT));
    }

    public void addBuildSrc() {
        this.addProjectFolder(this.project.getRootProject().file((Object)"buildSrc"));
    }

    private File getIdeDir() {
        return this.project.file(this.ideDir);
    }

    private File getWorkspaceDir() {
        return this.workspaceRegistry.workspaceDir(this.project, this.getIdeDir());
    }

    public void workspaceFile(String destination, Object fileSrc) {
        Object previousValue = this.workspaceFiles.put(destination, fileSrc);
        if (previousValue != null) {
            this.project.getLogger().warn("workspaceFile('" + destination + "', ...), was called more than once, previous value was discarded");
        }
    }

    public void workspaceProp(String destination, Action<Map<String, String>> configSupplier) {
        this.workspaceProps.merge(destination, configSupplier, (before, after) -> Actions.composite((Action[])new Action[]{before, after}));
    }

    public void workspaceXml(String destination, Action<XmlProvider> xmlSupplier) {
        this.workspaceXmls.merge(destination, xmlSupplier, (before, after) -> Actions.composite((Action[])new Action[]{before, after}));
    }

    public void addSetupAction(SetupAction internalSetupAction) {
        this.setupActions.getRoot().add(internalSetupAction);
    }

    public void addSetupActionLazy(Action<List<SetupAction>> lazyInternalSetupAction) {
        this.setupActions.addLazyAction(lazyInternalSetupAction);
    }

    public void linkedResource(String linkName, Object linkTarget) {
        String CORE_RES_PREFS_FILE = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.core.resources.prefs";
        String WS_PATHVAR_FMT = "pathvariable.%s";
        this.workspaceProp(".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.core.resources.prefs", (Action<Map<String, String>>)((Action)props -> props.put(String.format("pathvariable.%s", linkName), this.project.file(linkTarget).getAbsolutePath().replace("\\", "/"))));
    }

    String p2state() {
        StateBuilder state = new StateBuilder(this.project);
        state.add("ideDir", this.getIdeDir());
        state.add("p2", this.p2);
        state.addFile("icon", this.icon);
        state.addFile("splash", this.splash);
        state.add("name", this.name);
        state.add("perspective", this.perspective);
        return state.toString();
    }

    boolean p2isClean() throws IOException {
        return FileMisc.hasToken(this.getIdeDir(), STALE_TOKEN, this.p2state());
    }

    void ideSetupP2() throws Exception {
        if (this.p2isClean()) {
            return;
        }
        File ideDir = this.getIdeDir();
        FileMisc.cleanDir(ideDir);
        P2Model p2cached = new P2Model();
        p2cached.addArtifactRepoBundlePool();
        p2cached.copyFrom(this.p2);
        P2Model.DirectorApp app = p2cached.directorApp(ideDir, "OomphIde");
        app.consolelog();
        app.bundlepool(GoomphCacheLocations.bundlePool());
        app.platform(SwtPlatform.getRunning());
        this.directorModifier.execute((Object)app);
        this.runP2Using.execute((Object)app);
        this.writeBrandingPlugin(ideDir);
        this.setupEclipseIni(ideDir);
        FileMisc.writeToken(ideDir, STALE_TOKEN, this.p2state());
    }

    public void runP2Using(Action<P2Model.DirectorApp> runUsing) {
        this.runP2Using = runUsing;
    }

    public void runP2UsingPDE(String version) {
        this.runP2Using((Action<P2Model.DirectorApp>)((Action)directorApp -> Errors.rethrow().run(() -> directorApp.runUsing(PdeInstallation.from(EclipseRelease.official(version))))));
    }

    public void runP2UsingPDE() {
        this.runP2UsingPDE("4.19.0");
    }

    private BufferedImage loadImg(Object obj) throws IOException {
        File file = this.project.file(obj);
        Preconditions.checkArgument((boolean)file.isFile(), (String)"Image file %s does not exist!", (Object[])new Object[]{file});
        return ImageIO.read(this.project.file(obj));
    }

    void writeBrandingPlugin(File ideDir) throws IOException {
        BufferedImage splashImg;
        BufferedImage iconImg;
        int numSet = Booleans.countTrue((boolean[])new boolean[]{this.icon != null, this.splash != null});
        if (numSet == 0) {
            iconImg = BrandingProductPlugin.getGoomphIcon();
            splashImg = BrandingProductPlugin.getGoomphSplash();
        } else if (numSet == 1) {
            splashImg = iconImg = this.loadImg(Optional.ofNullable(this.icon).orElse(this.splash));
        } else if (numSet == 2) {
            iconImg = this.loadImg(this.icon);
            splashImg = this.loadImg(this.splash);
        } else {
            throw Unhandled.integerException((int)numSet);
        }
        File branding = new File(ideDir, FileMisc.macContentsEclipse() + "dropins/com.diffplug.goomph.branding");
        BrandingProductPlugin.create(branding, splashImg, iconImg, this.name, this.perspective, this.description);
        File bundlesInfo = new File(ideDir, FileMisc.macContentsEclipse() + "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        FileMisc.modifyFile(bundlesInfo, content -> content + "com.diffplug.goomph.branding,1.0.0,dropins/com.diffplug.goomph.branding/,4,true" + System.lineSeparator());
    }

    private void setupEclipseIni(File ideDir) throws FileNotFoundException, IOException {
        File iniFile = new File(ideDir, FileMisc.macContentsEclipse() + "eclipse.ini");
        EclipseIni ini = EclipseIni.parseFrom(iniFile);
        ini.set("-data", this.getWorkspaceDir());
        ini.set("-product", "com.diffplug.goomph.branding.product");
        File splashFile = new File(ideDir, FileMisc.macContentsEclipse() + "dropins/com.diffplug.goomph.branding/splash.bmp");
        ini.set("-showsplash", splashFile);
        ini.vmargs("-Xmx1g");
        File javaHome = new File(StandardSystemProperty.JAVA_HOME.value());
        boolean containsJava = Arrays.stream(javaHome.listFiles()).anyMatch(f -> f.isFile() && f.getName().equals("java"));
        if (!containsJava) {
            javaHome = new File(javaHome, "bin");
        }
        ini.set("-vm", javaHome.getCanonicalPath());
        if (OS.getNative().isMac()) {
            ini.set("-install", new File(ideDir, "Contents/MacOS"));
            ini.set("-configuration", new File(ideDir, "Contents/Eclipse/configuration"));
        }
        if (this.eclipseIni != null) {
            this.eclipseIni.execute((Object)ini);
        }
        ini.writeTo(iniFile);
    }

    boolean workspaceExists() {
        File workspaceDir = this.getWorkspaceDir();
        return workspaceDir.isDirectory() && !FileMisc.list(workspaceDir).isEmpty();
    }

    void ideSetupWorkspace() throws Throwable {
        if (this.workspaceExists()) {
            this.project.getLogger().lifecycle("Skipping ideSetupWorkspace because it already exists, run ideClean to force a rebuild.");
        }
        File workspaceDir = this.getWorkspaceDir();
        FileMisc.cleanDir(workspaceDir);
        this.workspaceFiles.forEach((path, src) -> {
            File target = new File(workspaceDir, (String)path);
            File srcFile = this.project.file(src);
            try {
                FileUtils.copyFile((File)srcFile, (File)target);
            }
            catch (IOException e) {
                throw new GradleException("error for workspaceFile('" + path + "', '" + srcFile + "'), maybe the source file does not exist?", (Throwable)e);
            }
        });
        this.workspaceProps.forEach((path, propAction) -> {
            File target = new File(workspaceDir, (String)path);
            try {
                Map<String, String> initial;
                if (target.exists()) {
                    initial = ConfigMisc.loadProps(target);
                } else {
                    initial = new LinkedHashMap<String, String>();
                    FileMisc.mkdirs(target.getParentFile());
                }
                propAction.execute(initial);
                ConfigMisc.writeProps(initial, target);
            }
            catch (IOException e) {
                throw new GradleException("error when writing workspaceProp '" + path + "'", (Throwable)e);
            }
        });
        this.workspaceXmls.forEach((path, xmlAction) -> {
            File target = new File(workspaceDir, (String)path);
            if (!target.exists()) {
                throw new GradleException("workspaceXml('" + path + "', ... must be initialized by a call to workspaceFile('" + path + "', ...");
            }
            try {
                ConfigMisc.modifyXmlInPlace(target, (Action<XmlProvider>)xmlAction);
            }
            catch (Exception e) {
                throw new GradleException("error when writing workspaceXml '" + path + "'", (Throwable)e);
            }
        });
        this.internalSetup(this.getIdeDir());
    }

    private void internalSetup(File ideDir) throws Throwable {
        List<SetupAction> list = this.setupActions.getResult();
        list.add(new ProjectImporter(this.projectFiles));
        List<SetupAction> ordered = SetupAction.order(list);
        ordered.add(new SaveWorkspace());
        SetupWithinEclipse internal = new SetupWithinEclipse(ideDir, ordered);
        JavaExecable.exec(this.project, internal, (Action<JavaExecSpec>)((Action)execSpec -> {
            FileCollection cp = execSpec.getClasspath().filter(file -> {
                String name = file.getName();
                return !name.startsWith("org.eclipse.") && !name.startsWith("biz.aQute.bndlib-");
            }).plus((FileCollection)this.project.files(new Object[]{EclipseIniLauncher.parseBundlesDotInfo(ideDir)}));
            execSpec.setClasspath(cp);
        }));
    }

    void ide() throws IOException {
        this.workspaceRegistry.clean();
        String launcher = (String)OS.getNative().winMacLinux((Object)"eclipse.exe", (Object)"Contents/MacOS/eclipse", (Object)"eclipse");
        String[] args = new String[]{this.getIdeDir().getAbsolutePath() + "/" + launcher};
        Runtime.getRuntime().exec(args, null, this.getIdeDir());
    }

    void ideClean() {
        FileUtils.deleteQuietly((File)this.getIdeDir());
        FileUtils.deleteQuietly((File)this.getWorkspaceDir());
    }

    public void style(Action<ConventionStyle> action) {
        OomphConvention.configure(ConventionStyle::new, this, action);
    }

    public void jdt(Action<ConventionJdt> action) {
        OomphConvention.configure(ConventionJdt::new, this, action);
    }

    public void pde(Action<ConventionPde> action) {
        OomphConvention.configure(ConventionPde::new, this, action);
    }

    public void thirdParty(Action<ConventionThirdParty> action) {
        OomphConvention.configure(ConventionThirdParty::new, this, action);
    }
}

