/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Unhandled;
import com.diffplug.common.io.Files;
import com.diffplug.common.primitives.Booleans;
import com.diffplug.common.swt.os.OS;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.ConfigMisc;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.GoomphCacheLocations;
import com.diffplug.gradle.JavaExecable;
import com.diffplug.gradle.Lazyable;
import com.diffplug.gradle.StateBuilder;
import com.diffplug.gradle.eclipserunner.EclipseIni;
import com.diffplug.gradle.oomph.BrandingProductPlugin;
import com.diffplug.gradle.oomph.ConventionJdt;
import com.diffplug.gradle.oomph.ConventionPde;
import com.diffplug.gradle.oomph.ConventionStyle;
import com.diffplug.gradle.oomph.ProjectImporter;
import com.diffplug.gradle.oomph.SaveWorkspace;
import com.diffplug.gradle.oomph.SetupAction;
import com.diffplug.gradle.oomph.SetupWithinEclipse;
import com.diffplug.gradle.oomph.WorkspaceRegistry;
import com.diffplug.gradle.p2.P2Declarative;
import com.diffplug.gradle.p2.P2Model;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Actions;
import org.gradle.plugins.ide.eclipse.GenerateEclipseProject;

public class OomphIdeExtension
implements P2Declarative {
    public static final String NAME = "oomphIde";
    final Project project;
    final WorkspaceRegistry workspaceRegistry;
    final SortedSet<File> projectFiles = new TreeSet<File>();
    final Map<String, Supplier<byte[]>> workspaceToContent = new HashMap<String, Supplier<byte[]>>();
    final P2Model p2 = new P2Model();
    final Lazyable<List<SetupAction>> setupActions = Lazyable.ofList();
    @Nonnull
    String name;
    @Nonnull
    String perspective;
    @Nonnull
    Object ideDir = "build/oomph-ide" + FileMisc.macApp();
    @Nonnull
    Action<P2Model.DirectorApp> directorModifier = Actions.doNothing();
    Action<EclipseIni> eclipseIni;
    Object icon;
    Object splash;
    private static final String DOT_PROJECT = ".project";
    static final String STALE_TOKEN = "token_stale";

    public OomphIdeExtension(Project project) throws IOException {
        this.project = Objects.requireNonNull(project);
        this.workspaceRegistry = WorkspaceRegistry.instance();
        this.name = project.getRootProject().getName();
        this.perspective = "org.eclipse.ui.resourcePerspective";
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public P2Model getP2() {
        return this.p2;
    }

    public void p2director(Action<P2Model.DirectorApp> directorModifier) {
        this.directorModifier = Objects.requireNonNull(directorModifier);
    }

    public void icon(Object icon) {
        this.icon = Objects.requireNonNull(icon);
    }

    public void splash(Object splash) {
        this.splash = Objects.requireNonNull(splash);
    }

    public void name(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public void perspective(String perspective) {
        this.perspective = Objects.requireNonNull(perspective);
    }

    public void eclipseIni(Action<EclipseIni> eclipseIni) {
        Preconditions.checkArgument((this.eclipseIni == null ? 1 : 0) != 0, (Object)"Can only set eclipseIni once");
        this.eclipseIni = eclipseIni;
    }

    public void ideDir(Object ideDir) {
        this.ideDir = Objects.requireNonNull(ideDir);
    }

    public void addAllProjects() {
        this.addAllProjects((Spec<String>)Specs.satisfyAll());
    }

    public void addAllProjects(Spec<String> include) {
        this.project.getRootProject().getAllprojects().forEach(p -> {
            if (p == this.project) {
                return;
            }
            if (include.isSatisfiedBy((Object)p.getPath())) {
                this.addDependency(this.project.evaluationDependsOn(p.getPath()));
            }
        });
    }

    public void addProject(String projectPath) {
        this.addDependency(this.project.evaluationDependsOn(projectPath));
    }

    void addDependency(Project eclipseProject) {
        Task ideSetup = this.project.getTasks().getByName("ideSetupWorkspace");
        eclipseProject.getTasks().all(task2 -> {
            if ("eclipse".equals(task2.getName())) {
                ideSetup.dependsOn(new Object[]{task2});
            }
            if (task2 instanceof GenerateEclipseProject) {
                File projectFile = ((GenerateEclipseProject)task2).getOutputFile();
                Preconditions.checkArgument((boolean)projectFile.getName().equals(DOT_PROJECT), (String)"Project file must be '.project', was %s", (Object[])new Object[]{projectFile});
                this.projectFiles.add(projectFile);
            }
        });
    }

    public void addProjectFolder(Object folderObj) {
        File folder = this.project.file(folderObj);
        Preconditions.checkArgument((boolean)folder.isDirectory(), (Object)"Folder '%s' must be a directory containing a '.project' file.");
        this.projectFiles.add(new File(folder, DOT_PROJECT));
    }

    private File getIdeDir() {
        return this.project.file(this.ideDir);
    }

    private File getWorkspaceDir() {
        return this.workspaceRegistry.workspaceDir(this.project, this.getIdeDir());
    }

    public void workspaceProp(String file, Action<Map<String, String>> configSupplier) {
        this.workspaceToContent.put(file, ConfigMisc.props(configSupplier));
    }

    public void addSetupAction(SetupAction internalSetupAction) {
        this.setupActions.getRoot().add(internalSetupAction);
    }

    public void addSetupActionLazy(Action<List<SetupAction>> lazyInternalSetupAction) {
        this.setupActions.addLazyAction(lazyInternalSetupAction);
    }

    String p2state() {
        StateBuilder state = new StateBuilder(this.project);
        state.add("ideDir", this.getIdeDir());
        state.add("p2", this.p2);
        state.addFile("icon", this.icon);
        state.addFile("splash", this.splash);
        state.add("name", this.name);
        state.add("perspective", this.perspective);
        return state.toString();
    }

    boolean p2isClean() throws IOException {
        return FileMisc.hasToken(this.getIdeDir(), STALE_TOKEN, this.p2state());
    }

    void ideSetupP2() throws Exception {
        if (this.p2isClean()) {
            return;
        }
        File ideDir = this.getIdeDir();
        FileMisc.cleanDir(ideDir);
        P2Model p2cached = new P2Model();
        p2cached.addArtifactRepoBundlePool();
        p2cached.copyFrom(this.p2);
        P2Model.DirectorApp app = p2cached.directorApp(ideDir, "OomphIde");
        app.consolelog();
        app.bundlepool(GoomphCacheLocations.bundlePool());
        app.platform(SwtPlatform.getRunning());
        this.directorModifier.execute((Object)app);
        app.runUsingBootstrapper(this.project);
        this.writeBrandingPlugin(ideDir);
        this.setupEclipseIni(ideDir);
        FileMisc.writeToken(ideDir, STALE_TOKEN, this.p2state());
    }

    private BufferedImage loadImg(Object obj) throws IOException {
        File file = this.project.file(obj);
        Preconditions.checkArgument((boolean)file.isFile(), (String)"Image file %s does not exist!", (Object[])new Object[]{file});
        return ImageIO.read(this.project.file(obj));
    }

    void writeBrandingPlugin(File ideDir) throws IOException {
        BufferedImage splashImg;
        BufferedImage iconImg;
        int numSet = Booleans.countTrue((boolean[])new boolean[]{this.icon != null, this.splash != null});
        if (numSet == 0) {
            iconImg = BrandingProductPlugin.getGoomphIcon();
            splashImg = BrandingProductPlugin.getGoomphSplash();
        } else if (numSet == 1) {
            splashImg = iconImg = this.loadImg(Optional.ofNullable(this.icon).orElse(this.splash));
        } else if (numSet == 2) {
            iconImg = this.loadImg(this.icon);
            splashImg = this.loadImg(this.splash);
        } else {
            throw Unhandled.integerException((int)numSet);
        }
        File branding = new File(ideDir, FileMisc.macContentsEclipse() + "dropins/com.diffplug.goomph.branding");
        BrandingProductPlugin.create(branding, splashImg, iconImg, this.name, this.perspective);
        File bundlesInfo = new File(ideDir, FileMisc.macContentsEclipse() + "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        FileMisc.modifyFile(bundlesInfo, content -> content + "com.diffplug.goomph.branding,1.0.0,dropins/com.diffplug.goomph.branding/,4,true" + System.lineSeparator());
    }

    private void setupEclipseIni(File ideDir) throws FileNotFoundException, IOException {
        File iniFile = new File(ideDir, FileMisc.macContentsEclipse() + "eclipse.ini");
        EclipseIni ini = EclipseIni.parseFrom(iniFile);
        ini.set("-data", this.getWorkspaceDir());
        ini.set("-product", "com.diffplug.goomph.branding.product");
        ini.set("-showsplash", "dropins/com.diffplug.goomph.branding/splash.bmp");
        if (OS.getNative().isMac()) {
            ini.set("-install", new File(ideDir, "Contents/MacOS"));
            ini.set("-configuration", new File(ideDir, "Contents/Eclipse/configuration"));
        }
        if (this.eclipseIni != null) {
            this.eclipseIni.execute((Object)ini);
        }
        ini.writeTo(iniFile);
    }

    boolean workspaceExists() {
        File workspaceDir = this.getWorkspaceDir();
        return workspaceDir.isDirectory() && !FileMisc.list(workspaceDir).isEmpty();
    }

    void ideSetupWorkspace() throws Exception {
        if (this.workspaceExists()) {
            this.project.getLogger().lifecycle("Skipping ideSetupWorkspace because it already exists, run ideClean to force a rebuild.");
        }
        File workspaceDir = this.getWorkspaceDir();
        FileMisc.cleanDir(workspaceDir);
        this.workspaceToContent.forEach((path, content) -> {
            File target = new File(workspaceDir, (String)path);
            FileMisc.mkdirs(target.getParentFile());
            Errors.rethrow().run(() -> OomphIdeExtension.lambda$null$79((Supplier)content, target));
        });
        this.internalSetup(this.getIdeDir());
    }

    private void internalSetup(File ideDir) throws IOException {
        List<SetupAction> list = this.setupActions.getResult();
        list.add(new ProjectImporter(this.projectFiles));
        List<SetupAction> ordered = SetupAction.order(list);
        ordered.add(new SaveWorkspace());
        SetupWithinEclipse internal = new SetupWithinEclipse(ideDir, ordered);
        Errors.constrainTo(IOException.class).run(() -> JavaExecable.exec(this.project, internal));
    }

    void ide() throws IOException {
        this.workspaceRegistry.clean();
        String launcher = (String)OS.getNative().winMacLinux((Object)"eclipse.exe", (Object)"Contents/MacOS/eclipse", (Object)"eclipse");
        String[] args = new String[]{this.getIdeDir().getAbsolutePath() + "/" + launcher};
        Runtime.getRuntime().exec(args, null, this.getIdeDir());
    }

    void ideClean() {
        FileUtils.deleteQuietly((File)this.getIdeDir());
        FileUtils.deleteQuietly((File)this.getWorkspaceDir());
    }

    public void style(Action<ConventionStyle> action) {
        ConventionStyle convention = new ConventionStyle(this);
        action.execute((Object)convention);
    }

    public void jdt(Action<ConventionJdt> action) {
        ConventionJdt convention = new ConventionJdt(this);
        action.execute((Object)convention);
    }

    public void pde(Action<ConventionPde> action) {
        ConventionPde convention = new ConventionPde(this);
        action.execute((Object)convention);
    }

    private static /* synthetic */ void lambda$null$79(Supplier supplier, File file) throws Throwable {
        Files.write((byte[])((byte[])supplier.get()), (File)file);
    }
}

