/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse.apt;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.util.Node;
import groovy.util.NodeList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class Factorypath
extends XmlPersistableConfigurationObject {
    private List<File> entries = new ArrayList<File>();

    Factorypath(XmlTransformer xmlTransformer) {
        super(xmlTransformer);
    }

    protected String getDefaultResourceName() {
        return "defaultFactorypath.xml";
    }

    protected void load(Node xml) {
        for (Object e : (NodeList)xml.get("factorypathentry")) {
            Node entryNode = (Node)e;
            if (!Factorypath.isFileEntry(entryNode)) continue;
            this.entries.add(new File((String)entryNode.attribute((Object)"id")));
        }
    }

    void mergeEntries(Collection<File> newEntries) {
        LinkedHashSet<File> updatedEntries = new LinkedHashSet<File>();
        for (File f : this.entries) {
            updatedEntries.add(f.getAbsoluteFile());
        }
        for (File f : newEntries) {
            updatedEntries.add(f.getAbsoluteFile());
        }
        this.entries = new ArrayList<File>(updatedEntries);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    protected void store(Node xml) {
        for (Object e : (NodeList)xml.get("factorypathentry")) {
            Node entryNode = (Node)e;
            if (!Factorypath.isFileEntry(entryNode)) continue;
            xml.remove(entryNode);
        }
        for (File entry : this.entries) {
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
            attributes.put("kind", "EXTJAR");
            attributes.put("id", entry.getAbsolutePath());
            attributes.put("enabled", true);
            attributes.put("runInBatchMode", false);
            xml.appendNode((Object)"factorypathentry", attributes);
        }
    }

    public List<File> getEntries() {
        return this.entries;
    }

    public void setEntries(List<File> entries) {
        this.entries = entries;
    }

    private static boolean isFileEntry(Node entryNode) {
        return "EXTJAR".equals(entryNode.attribute((Object)"kind")) && Boolean.valueOf(String.valueOf(entryNode.attribute((Object)"enabled"))) != false;
    }
}

