/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.base.Box;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Throwing;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.GoomphCacheLocations;
import com.diffplug.gradle.ZipMisc;
import com.diffplug.gradle.pde.EclipseRelease;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MavenCentralMapping {
    private static final EclipseRelease FIRST_ON_CENTRAL = EclipseRelease.official("4.6.2");
    private static final String PLATFORM = "org.eclipse.platform";
    private static final String JDT = "org.eclipse.jdt";
    private static final String PDE = "org.eclipse.pde";
    private static final String EMF = "org.eclipse.emf";
    private static final String ECF = "org.eclipse.ecf";
    private static final String ICU_BUNDLE_ID = "com.ibm.icu";
    private static final String ARTIFACTS_JAR = "artifacts.jar";

    public static boolean isEclipseGroup(String group) {
        return group.equals(PLATFORM) || group.equals(JDT) || group.equals(PDE) || group.equals(EMF) || group.equals(ECF);
    }

    public static String groupIdArtifactId(String bundleId) {
        if (ICU_BUNDLE_ID.equals(bundleId)) {
            return "com.ibm.icu:icu4j";
        }
        if ("org.eclipse.jdt.core.compiler.batch".equals(bundleId)) {
            return "org.eclipse.jdt:ecj";
        }
        if (bundleId.startsWith(JDT)) {
            return "org.eclipse.jdt:" + bundleId;
        }
        if (bundleId.startsWith(PDE)) {
            return "org.eclipse.pde:" + bundleId;
        }
        if (bundleId.startsWith(EMF)) {
            return "org.eclipse.emf:" + bundleId;
        }
        if (bundleId.startsWith(ECF)) {
            return "org.eclipse.ecf:" + bundleId;
        }
        return "org.eclipse.platform:" + bundleId;
    }

    static Map<String, String> parse(InputStream inputStream, Function<String, String> keyExtractor) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(inputStream);
        Node artifacts = doc.getDocumentElement().getElementsByTagName("artifacts").item(0);
        for (int i = 0; i < artifacts.getChildNodes().getLength(); ++i) {
            String classifier;
            Node artifact = artifacts.getChildNodes().item(i);
            if (!"artifact".equals(artifact.getNodeName()) || !"osgi.bundle".equals(classifier = artifact.getAttributes().getNamedItem("classifier").getNodeValue())) continue;
            String bundleId = artifact.getAttributes().getNamedItem("id").getNodeValue();
            String bundleVersion = artifact.getAttributes().getNamedItem("version").getNodeValue();
            String key = keyExtractor.apply(bundleId);
            String version = MavenCentralMapping.calculateMavenCentralVersion(bundleId, bundleVersion);
            map.put(key, version);
        }
        return map;
    }

    static String calculateMavenCentralVersion(String bundleId, String bundleVersion) {
        Version parsed = Version.parseVersion((String)bundleVersion);
        if (ICU_BUNDLE_ID.equals(bundleId) && parsed.getMicro() == 0) {
            return parsed.getMajor() + "." + parsed.getMinor();
        }
        return parsed.getMajor() + "." + parsed.getMinor() + "." + parsed.getMicro();
    }

    public static Map<String, String> bundleToVersion(EclipseRelease release) {
        return MavenCentralMapping.createVersionMap(release, Function.identity());
    }

    public static Map<String, String> groupIdArtifactIdToVersion(EclipseRelease release) {
        return MavenCentralMapping.createVersionMap(release, MavenCentralMapping::groupIdArtifactId);
    }

    private static Map<String, String> createVersionMap(EclipseRelease release, Function<String, String> keyExtractor) {
        if (release.version().compareTo(FIRST_ON_CENTRAL.version()) < 0) {
            throw new IllegalArgumentException(FIRST_ON_CENTRAL.version() + " was the first eclipse release that was published on maven central, you requested " + release);
        }
        if (!release.isXYZ()) {
            throw new IllegalArgumentException("Maven central mapping requires 'x.y.z' and does not support 'x.y'.  Try " + release + ".0 instead of " + release);
        }
        File versionFolder = new File(GoomphCacheLocations.eclipseReleaseMetadata(), release.version().toString());
        FileMisc.mkdirs(versionFolder);
        File artifactsJar = new File(versionFolder, ARTIFACTS_JAR);
        if (artifactsJar.exists() && artifactsJar.length() > 0L) {
            try {
                return MavenCentralMapping.parseFromFile(artifactsJar, keyExtractor);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Retrying download...");
                FileMisc.forceDelete(artifactsJar);
            }
        }
        return (Map)Errors.rethrow().get(() -> {
            FileMisc.download(release.updateSite() + ARTIFACTS_JAR, artifactsJar);
            return MavenCentralMapping.parseFromFile(artifactsJar, keyExtractor);
        });
    }

    private static Map<String, String> parseFromFile(File artifactsJar, Function<String, String> keyExtractor) throws IOException {
        Box.Nullable value = Box.Nullable.ofNull();
        ZipMisc.read(artifactsJar, "artifacts.xml", (Throwing.Specific.Consumer<InputStream, IOException>)((Throwing.Specific.Consumer)input -> value.set(Errors.rethrow().get(() -> MavenCentralMapping.parse(input, keyExtractor)))));
        return (Map)Objects.requireNonNull(value.get());
    }
}

