/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.eclipse.MavenCentralMapping;
import com.diffplug.gradle.pde.EclipseRelease;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionSelector;

public class MavenCentralExtension {
    public static final String NAME = "eclipseMavenCentral";
    private final Project project;

    public MavenCentralExtension(Project project) {
        this.project = Objects.requireNonNull(project);
    }

    public void release(String version, Action<ReleaseConfigurer> configurer) throws IOException {
        this.release(EclipseRelease.official(version), configurer);
    }

    public void release(EclipseRelease release, Action<ReleaseConfigurer> configurer) throws IOException {
        configurer.execute((Object)new ReleaseConfigurer(release));
    }

    public class ReleaseConfigurer {
        final EclipseRelease release;
        final Map<String, String> groupIdArtifactIdToVersion;
        private static final String $_OSGI_PLATFORM = "${osgi.platform}";

        public ReleaseConfigurer(EclipseRelease release) throws IOException {
            this.release = release;
            this.groupIdArtifactIdToVersion = MavenCentralMapping.groupIdArtifactIdToVersion(release);
        }

        public void compileOnly(String bundleId) {
            this.dep("compileOnly", bundleId);
        }

        public void testCompileOnly(String bundleId) {
            this.dep("testCompileOnly", bundleId);
        }

        public void api(String bundleId) {
            this.dep("api", bundleId);
        }

        public void implementation(String bundleId) {
            this.dep("implementation", bundleId);
        }

        public void testImplementation(String bundleId) {
            this.dep("testImplementation", bundleId);
        }

        public void runtimeOnly(String bundleId) {
            this.dep("runtimeOnly", bundleId);
        }

        public void testRuntimeOnly(String bundleId) {
            this.dep("testRuntimeOnly", bundleId);
        }

        public void dep(String configName, String bundleId) {
            String groupIdArtifactId = MavenCentralMapping.groupIdArtifactId(bundleId);
            String version = this.groupIdArtifactIdToVersion.get(groupIdArtifactId);
            if (version == null) {
                throw new IllegalArgumentException(StringPrinter.buildString(printer -> {
                    printer.println("Eclipse " + this.release + " has no bundle named " + bundleId);
                    TreeMap<String, String> versions = new TreeMap<String, String>(this.groupIdArtifactIdToVersion);
                    versions.forEach((key, value) -> printer.println("  " + key + "=" + value));
                }));
            }
            MavenCentralExtension.this.project.getDependencies().add(configName, (Object)(groupIdArtifactId + ":" + version));
        }

        public void useNativesForRunningPlatform() {
            MavenCentralExtension.this.project.getConfigurations().all(config -> config.getResolutionStrategy().eachDependency(details -> {
                ModuleVersionSelector req = details.getRequested();
                if (req.getName().contains($_OSGI_PLATFORM)) {
                    String running = SwtPlatform.getRunning().toString();
                    details.useTarget((Object)(req.getGroup() + ":" + req.getName().replace($_OSGI_PLATFORM, running) + ":" + req.getVersion()));
                }
            }));
        }

        public void constrainTransitivesToThisRelease() {
            this.constrainTransitivesToThisReleaseExcept(new String[0]);
        }

        public void constrainTransitivesToThisReleaseExcept(String ... artifactNames) {
            List<String> names = Arrays.asList(artifactNames);
            MavenCentralExtension.this.project.getConfigurations().forEach(config -> config.getResolutionStrategy().eachDependency(dep -> {
                String version;
                ModuleVersionSelector mod = dep.getRequested();
                if (!names.contains(mod.getName()) && (version = this.groupIdArtifactIdToVersion.get(mod.getGroup() + ":" + mod.getName())) != null) {
                    dep.useVersion(version);
                }
            }));
        }

        public void compileOnlyNative(String bundleId) {
            this.nativeDep("compileOnly", bundleId);
        }

        public void testCompileOnlyNative(String bundleId) {
            this.nativeDep("testCompileOnly", bundleId);
        }

        public void apiNative(String bundleId) {
            this.nativeDep("api", bundleId);
        }

        public void implementationNative(String bundleId) {
            this.nativeDep("implementation", bundleId);
        }

        public void testImplementationNative(String bundleId) {
            this.nativeDep("testImplementation", bundleId);
        }

        public void runtimeOnlyNative(String bundleId) {
            this.nativeDep("runtimeOnly", bundleId);
        }

        public void testRuntimeOnlyNative(String bundleId) {
            this.nativeDep("testRuntimeOnly", bundleId);
        }

        public void nativeDep(String configName, String bundleId) {
            SwtPlatform platform = SwtPlatform.getRunning();
            this.dep(configName, bundleId + "." + platform);
        }
    }
}

