/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableMisc {
    public static <T extends Serializable> void write(File file, T object) throws IOException {
        try (ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            output.writeObject(object);
        }
    }

    public static <T extends Serializable> T read(File file) throws ClassNotFoundException, IOException {
        try (ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
            Serializable serializable = (Serializable)input.readObject();
            return (T)serializable;
        }
    }

    public static void writeThrowable(File file, Throwable object) throws IOException {
        try {
            SerializableMisc.write(file, object);
        }
        catch (NotSerializableException e) {
            SerializableMisc.write(file, new ThrowableCopy(object));
        }
    }

    static class ThrowableCopy
    extends Throwable {
        private static final long serialVersionUID = -4674520369975786435L;

        ThrowableCopy(Throwable source) {
            super(source.getClass().getName() + ": " + source.getMessage());
            this.setStackTrace(source.getStackTrace());
            if (source.getCause() != null) {
                this.initCause(new ThrowableCopy(source.getCause()));
            }
        }
    }
}

