/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.gradle.JavaExecable;
import com.diffplug.gradle.eclipserunner.EclipseIniLauncher;
import com.diffplug.gradle.oomph.SetupAction;
import com.diffplug.gradle.osgi.OsgiExecable;
import java.io.File;
import java.util.List;
import java.util.Objects;

class SetupWithinEclipse
implements JavaExecable {
    private static final long serialVersionUID = -7563836594137010936L;
    File eclipseRoot;
    List<SetupAction> actionsWithinEclipse;

    public SetupWithinEclipse(File eclipseRoot, List<SetupAction> list) {
        this.eclipseRoot = Objects.requireNonNull(eclipseRoot);
        this.actionsWithinEclipse = Objects.requireNonNull(list);
    }

    public void run() throws Throwable {
        EclipseIniLauncher launcher = new EclipseIniLauncher(this.eclipseRoot);
        try (EclipseIniLauncher.Running running = launcher.open();){
            System.out.println("Running internal setup actions...");
            for (SetupAction action : this.actionsWithinEclipse) {
                System.out.print("    " + action.getDescription() + "... ");
                OsgiExecable.exec(running.bundleContext(), action);
                System.out.println("done.");
            }
            System.out.println("Internal setup complete.");
        }
    }
}

