/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.osgi.framework.Version;

public final class EclipseRelease {
    final String id;
    final Version version;
    final String updateSite;
    public static final String LATEST = "4.6.2";

    private EclipseRelease(String id, Version version, String updateSite) {
        this.id = id;
        this.version = version;
        this.updateSite = updateSite;
    }

    public static EclipseRelease createWithIdVersionUpdatesite(String id, String version, String updateSite) {
        EclipseRelease official = EclipseRelease.officialReleaseMaybe(id);
        if (official != null) {
            throw new IllegalArgumentException("User-generated version cannot conflict with built-in " + id + ", change the ID or use EclipseRelease.forVersion(" + id + ")");
        }
        return new EclipseRelease(Objects.requireNonNull(id), Version.parseVersion((String)version), Objects.requireNonNull(updateSite));
    }

    public static EclipseRelease official(String version) {
        EclipseRelease release = EclipseRelease.officialReleaseMaybe(version);
        if (release == null) {
            throw new IllegalArgumentException(version + " is not supported.  We only support " + EclipseRelease.supportedRange());
        }
        return release;
    }

    public static EclipseRelease latestOfficial() {
        return EclipseRelease.official(LATEST);
    }

    public static String supportedRange() {
        return "3.5.0 through 4.6.2";
    }

    @Nullable
    private static EclipseRelease officialReleaseMaybe(String version) {
        Function<String, String> updateSiteFunc = v -> {
            String root = "http://download.eclipse.org/eclipse/updates/";
            switch (v) {
                case "3.5.0": {
                    return root + "3.5/R-3.5-200906111540/";
                }
                case "3.5.1": {
                    return root + "3.5/R-3.5.1-200909170800/";
                }
                case "3.5.2": {
                    return root + "3.5/R-3.5.2-201002111343/";
                }
                case "3.6.0": {
                    return root + "3.6/R-3.6-201006080911/";
                }
                case "3.6.1": {
                    return root + "3.6/R-3.6.1-201009090800/";
                }
                case "3.6.2": {
                    return root + "3.6/R-3.6.2-201102101200/";
                }
                case "3.7.0": {
                    return root + "3.7/R-3.7-201106131736/";
                }
                case "3.7.1": {
                    return root + "3.7/R-3.7.1-201109091335/";
                }
                case "3.7.2": {
                    return root + "3.7/R-3.7.2-201202080800/";
                }
                case "3.8.0": {
                    return root + "3.8/R-3.8-201206081200/";
                }
                case "3.8.1": {
                    return root + "3.8/R-3.8.1-201209141540/";
                }
                case "3.8.2": {
                    return root + "3.8/R-3.8.2-201301310800/";
                }
                case "4.2.0": {
                    return root + "4.2/R-4.2-201206081400/";
                }
                case "4.2.1": {
                    return root + "4.2/R-4.2.1-201209141800/";
                }
                case "4.2.2": {
                    return root + "4.2/R-4.2.2-201302041200/";
                }
                case "4.3.0": {
                    return root + "4.3/R-4.3-201306052000/";
                }
                case "4.3.1": {
                    return root + "4.3/R-4.3.1-201309111000/";
                }
                case "4.3.2": {
                    return root + "4.3/R-4.3.2-201402211700/";
                }
                case "4.4.0": {
                    return root + "4.4/R-4.4-201406061215/";
                }
                case "4.4.1": {
                    return root + "4.4/R-4.4.1-201409250400/";
                }
                case "4.4.2": {
                    return root + "4.4/R-4.4.2-201502041700/";
                }
                case "4.5.0": {
                    return root + "4.5/R-4.5-201506032000/";
                }
                case "4.5.1": {
                    return root + "4.5/R-4.5.1-201509040015/";
                }
                case "4.5.2": {
                    return root + "4.5/R-4.5.2-201602121500/";
                }
                case "4.6.0": {
                    return root + "4.6/R-4.6-201606061100/";
                }
                case "4.6.1": {
                    return root + "4.6/R-4.6.1-201609071200/";
                }
                case "4.6.2": {
                    return root + "4.6/R-4.6.2-201611241400/";
                }
                case "3.5": 
                case "3.6": 
                case "3.7": 
                case "3.8": 
                case "4.2": 
                case "4.3": 
                case "4.4": 
                case "4.5": 
                case "4.6": {
                    return root + v + "/";
                }
            }
            return null;
        };
        String updateSite = updateSiteFunc.apply(version);
        if (updateSite == null) {
            return null;
        }
        return new EclipseRelease(version, Version.parseVersion((String)version), updateSite);
    }

    public Version version() {
        return this.version;
    }

    public String updateSite() {
        return this.updateSite;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.updateSite);
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof EclipseRelease) {
            EclipseRelease other = (EclipseRelease)otherObj;
            return this.id.equals(other.id) && this.version.equals((Object)other.version) && this.updateSite.equals(other.updateSite);
        }
        return false;
    }
}

