/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.io.ByteSink;
import com.diffplug.common.io.ByteSource;
import com.diffplug.common.io.ByteStreams;
import com.diffplug.gradle.FileMisc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipMisc {
    public static void read(File input, String toRead, Throwing.Specific.Consumer<InputStream, IOException> reader) throws IOException {
        try (ZipFile file = new ZipFile(input);
             InputStream stream = file.getInputStream(file.getEntry(toRead));){
            reader.accept((Object)stream);
        }
    }

    public static String read(File input, String toRead) throws IOException {
        String raw = StringPrinter.buildString((Consumer)Errors.rethrow().wrap(printer -> ZipMisc.read(input, toRead, (Throwing.Specific.Consumer<InputStream, IOException>)((Throwing.Specific.Consumer)inputStream -> ZipMisc.copy(inputStream, printer.toOutputStream(StandardCharsets.UTF_8))))));
        return FileMisc.toUnixNewline(raw);
    }

    public static void modify(ByteSource input, ByteSink output, Map<String, Function<byte[], byte[]>> toModify, Predicate<String> toOmit) throws IOException {
        try (ZipInputStream zipInput = new ZipInputStream(input.openBufferedStream());
             ZipOutputStream zipOutput = new ZipOutputStream(output.openBufferedStream());){
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                Function<byte[], byte[]> replacement = toModify.get(entry.getName());
                if (replacement != null) {
                    byte[] clean = ByteStreams.toByteArray((InputStream)zipInput);
                    byte[] modified = replacement.apply(clean);
                    try (ByteArrayInputStream replacementStream = new ByteArrayInputStream(modified);){
                        ZipEntry newEntry = new ZipEntry(entry.getName());
                        newEntry.setComment(entry.getComment());
                        newEntry.setExtra(entry.getExtra());
                        newEntry.setMethod(entry.getMethod());
                        newEntry.setTime(entry.getTime());
                        zipOutput.putNextEntry(newEntry);
                        ZipMisc.copy(replacementStream, zipOutput);
                    }
                } else if (!toOmit.test(entry.getName())) {
                    ZipEntry newEntry = new ZipEntry(entry);
                    newEntry.setCompressedSize(-1L);
                    zipOutput.putNextEntry(newEntry);
                    ZipMisc.copy(zipInput, zipOutput);
                }
                zipInput.closeEntry();
                zipOutput.closeEntry();
            }
        }
    }

    public static void zip(File input, String pathWithinArchive, File output) throws IOException {
        try (ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output)));){
            zipStream.setMethod(8);
            zipStream.setLevel(9);
            zipStream.putNextEntry(new ZipEntry(pathWithinArchive));
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(input));){
                ZipMisc.copy(inputStream, zipStream);
            }
        }
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        IOUtils.copy((InputStream)input, (OutputStream)output);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(File input, File destinationDir) throws IOException {
        try (ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(input)));){
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                BufferedOutputStream output;
                block23: {
                    File dest = new File(destinationDir, entry.getName());
                    if (entry.isDirectory()) {
                        FileMisc.mkdirs(dest);
                        continue;
                    }
                    FileMisc.mkdirs(dest.getParentFile());
                    output = new BufferedOutputStream(new FileOutputStream(dest));
                    Throwable throwable = null;
                    try {
                        ZipMisc.copy(zipInput, output);
                        if (output == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (output == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)output).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)output).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)output).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)output).close();
            }
            return;
        }
    }
}

