/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipserunner;

import com.diffplug.common.base.Unhandled;
import com.diffplug.gradle.eclipserunner.EquinoxLaunchSetupTask;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.LazyForwardingEquality;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.bundling.Jar;

public class EquinoxLaunchSource
extends LazyForwardingEquality<FileSignature> {
    private static final long serialVersionUID = 3644633962761683264L;
    final transient EquinoxLaunchSetupTask setupTask;
    transient List<Object> projConfigMaven = new ArrayList<Object>();

    EquinoxLaunchSource(EquinoxLaunchSetupTask setupTask) {
        this.setupTask = setupTask;
    }

    public void addThisProject() {
        this.addProject(this.setupTask.getProject());
    }

    public void addProject(Project project) {
        Jar jar = EquinoxLaunchSource.taskFor(project);
        this.setupTask.dependsOn(new Object[]{jar});
        this.projConfigMaven.add(project);
    }

    public void addConfiguration(Configuration config) {
        this.projConfigMaven.add(config);
    }

    public void addMaven(String mavenCoord) {
        this.projConfigMaven.add(mavenCoord);
    }

    private static Jar taskFor(Project project) {
        return (Jar)project.getTasks().getByName("jar");
    }

    protected FileSignature calculateState() throws Exception {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (Object o : this.projConfigMaven) {
            if (o instanceof Project) {
                Project project = (Project)o;
                Jar jar = EquinoxLaunchSource.taskFor(project);
                files.add(((RegularFile)jar.getArchiveFile().get()).getAsFile());
                files.addAll(project.getConfigurations().getByName("runtimeClasspath").resolve());
                continue;
            }
            if (o instanceof Configuration) {
                Configuration config = (Configuration)o;
                files.addAll(config.resolve());
                continue;
            }
            if (o instanceof String) {
                String mavenCoord = (String)o;
                Dependency dep = this.setupTask.getProject().getDependencies().create((Object)mavenCoord);
                files.addAll(this.setupTask.getProject().getConfigurations().detachedConfiguration(new Dependency[]{dep}).setDescription(mavenCoord).setTransitive(false).resolve());
                continue;
            }
            throw Unhandled.classException((Object)o);
        }
        return FileSignature.from(files);
    }

    public Collection<File> resolvedFiles() {
        return ((FileSignature)this.state()).files();
    }
}

