/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.swt;

import com.diffplug.common.swt.os.OS;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.Settings;
import org.gradle.api.provider.Provider;

public class PlatformSpecificBuildPlugin
implements Plugin<Settings> {
    static final String STOP_FORUSE_AT_CONFIGURATION_TIME = "7.4";
    private static final Pattern BAD_SEMVER = Pattern.compile("(\\d+)\\.(\\d+)");

    public void apply(Settings settings) {
        OS.detectPlatform(systemProp -> (String)this.get(settings, settings.getProviders().systemProperty(systemProp)), envVar -> (String)this.get(settings, settings.getProviders().environmentVariable(envVar)), cmds -> (String)this.get(settings, settings.getProviders().exec(e -> e.commandLine(cmds.toArray())).getStandardOutput().getAsText()));
    }

    private <T> T get(Settings settings, Provider<T> provider) {
        if (PlatformSpecificBuildPlugin.badSemver(settings.getGradle().getGradleVersion()) >= PlatformSpecificBuildPlugin.badSemver(STOP_FORUSE_AT_CONFIGURATION_TIME)) {
            return (T)provider.get();
        }
        return (T)provider.forUseAtConfigurationTime().get();
    }

    private static int badSemver(String input) {
        Matcher matcher = BAD_SEMVER.matcher(input);
        if (!matcher.find() || matcher.start() != 0) {
            throw new IllegalArgumentException("Version must start with " + BAD_SEMVER.pattern());
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        return PlatformSpecificBuildPlugin.badSemver(Integer.parseInt(major), Integer.parseInt(minor));
    }

    private static int badSemver(int major, int minor) {
        return major * 1000000 + minor;
    }
}

