/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.common;

import com.jmatio.common.AbstractIterator;
import com.jmatio.common.ForwardingCollection;
import com.jmatio.common.ForwardingMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DeterministicKeyMap<K, V>
extends ForwardingMap<K, V> {
    private final Set<K> keyOrder;
    static final Function<Object, Object> identity = new Function<Object, Object>(){

        @Override
        public Object apply(Object input) {
            return input;
        }
    };

    public DeterministicKeyMap(Set<K> keyOrder, Map<K, V> delegate) {
        super(delegate);
        this.keyOrder = keyOrder;
    }

    @Override
    public Set<K> keySet() {
        return new DeterministicSet<Object>(this.delegate.keySet(), identity);
    }

    @Override
    public Collection<V> values() {
        return new DeterministicCollection(this.delegate.values(), new Function<K, V>(){

            @Override
            public V apply(K input) {
                return DeterministicKeyMap.this.delegate.get(input);
            }
        });
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new DeterministicSet(this.delegate.entrySet(), new Function<K, Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> apply(final K key) {
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public V getValue() {
                        return DeterministicKeyMap.this.delegate.get(key);
                    }

                    @Override
                    public V setValue(V value) {
                        return DeterministicKeyMap.this.delegate.put(key, value);
                    }
                };
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    class DeterministicCollection<T>
    extends ForwardingCollection<T> {
        Function<K, T> keyToValue;

        DeterministicCollection(Collection<T> delegate, Function<K, T> keyToValue) {
            super(delegate);
            this.keyToValue = keyToValue;
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator iterByKey = DeterministicKeyMap.this.keyOrder.iterator();
            return new AbstractIterator<T>(){

                @Override
                protected T computeNext() {
                    while (iterByKey.hasNext()) {
                        Object nextKey = iterByKey.next();
                        Object value = DeterministicCollection.this.keyToValue.apply(nextKey);
                        if (!DeterministicCollection.this.delegate.contains(value)) continue;
                        return value;
                    }
                    return this.endOfData();
                }
            };
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    class DeterministicSet<T>
    extends DeterministicCollection<T>
    implements Set<T> {
        DeterministicSet(Set<T> delegate, Function<K, T> keyToValue) {
            super(delegate, keyToValue);
        }
    }

    static interface Function<T, R> {
        public R apply(T var1);
    }
}

