/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class ForwardingCollection<T>
implements Collection<T> {
    protected final Collection<T> delegate;

    protected ForwardingCollection(Collection<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        return this.toArray((R[])result);
    }

    @Override
    public <R> R[] toArray(R[] a) {
        ArrayList<T> result = new ArrayList<T>(this.size());
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result.toArray(a);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean add(T e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }
}

