/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatFileReader;
import com.jmatio.io.MatFileType;
import com.jmatio.types.MLArray;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Map;

public class MatFile {
    private final MatFileHeader header;
    private final Map<String, MLArray> content;

    public MatFile(MatFileHeader header, Map<String, MLArray> content) {
        this.header = header;
        this.content = content;
    }

    public MatFileHeader getHeader() {
        return this.header;
    }

    public Map<String, MLArray> getContent() {
        return this.content;
    }

    public static Map<String, MLArray> readBare(MatFileHeader header, ByteBuffer buffer) throws IOException {
        MatFileReader reader = new MatFileReader();
        reader.matFileHeader = header;
        buffer.order(header.getByteOrder());
        reader.readData(buffer);
        return reader.data;
    }

    public static MatFile readFull(ByteBuffer buf) throws IOException {
        return MatFile.readFull(buf, MatFileType.Regular);
    }

    public static MatFile readFull(ByteBuffer buf, MatFileType type) throws IOException {
        MatFileReader reader = new MatFileReader(type);
        reader.readHeader(buf);
        while (buf.remaining() > 0) {
            reader.readData(buf);
        }
        return new MatFile(reader.getMatFileHeader(), reader.getContent());
    }

    public static MatFile readFull(RandomAccessFile file) throws IOException {
        MatFileReader reader = new MatFileReader();
        reader.read(file, new MatFileFilter(), 4);
        return new MatFile(reader.getMatFileHeader(), reader.getContent());
    }
}

