/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SimulinkDecoder
extends InputStream {
    private final byte[] input;
    private int pos;
    private byte leftover;
    private final Map<Byte, Byte> decoderRing = new HashMap<Byte, Byte>();

    public SimulinkDecoder(String input) {
        try {
            this.input = input.getBytes("UTF-8");
            for (byte i = 0; i < 64; i = (byte)(i + 1)) {
                this.decoderRing.put((byte)(i + 32), i);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int ret;
            switch (this.pos % 4) {
                case 0: {
                    byte first = this.decoderRing.get(this.input[this.pos++]);
                    byte second = this.decoderRing.get(this.input[this.pos++]);
                    ret = first << 2 | second >> 4;
                    this.leftover = (byte)(second & 0xF);
                    break;
                }
                case 2: {
                    byte next = this.decoderRing.get(this.input[this.pos++]);
                    ret = this.leftover << 4 | next >> 2;
                    this.leftover = (byte)(next & 3);
                    break;
                }
                case 3: {
                    byte next = this.decoderRing.get(this.input[this.pos++]);
                    ret = this.leftover << 6 | next;
                    break;
                }
                case -1: {
                    return -1;
                }
                default: {
                    throw new RuntimeException("Case " + this.pos % 4);
                }
            }
            return ret;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.pos = -1;
            return -1;
        }
    }
}

