/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io.stream;

import com.jmatio.common.MatDataTypes;
import com.jmatio.types.ByteStorageSupport;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MatFileInputStream {
    private final int type;
    private final ByteBuffer buf;

    public MatFileInputStream(ByteBuffer buf, int type) {
        this.type = type;
        this.buf = buf;
    }

    public int readInt() throws IOException {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt();
            }
            case 5: {
                return this.buf.getInt();
            }
            case 13: {
                return (int)this.buf.getLong();
            }
            case 12: {
                return (int)this.buf.getLong();
            }
            case 9: {
                return (int)this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public char readChar() throws IOException {
        switch (this.type) {
            case 2: {
                return (char)(this.buf.get() & 0xFF);
            }
            case 1: {
                return (char)this.buf.get();
            }
            case 4: {
                return (char)(this.buf.getShort() & 0xFFFF);
            }
            case 3: {
                return (char)this.buf.getShort();
            }
            case 6: {
                return (char)this.buf.getInt();
            }
            case 5: {
                return (char)this.buf.getInt();
            }
            case 9: {
                return (char)this.buf.getDouble();
            }
            case 16: {
                return (char)this.buf.get();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public double readDouble() throws IOException {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt();
            }
            case 5: {
                return this.buf.getInt();
            }
            case 9: {
                return this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public byte readByte() {
        switch (this.type) {
            case 2: {
                return (byte)(this.buf.get() & 0xFF);
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return (byte)(this.buf.getShort() & 0xFFFF);
            }
            case 3: {
                return (byte)this.buf.getShort();
            }
            case 6: {
                return (byte)this.buf.getInt();
            }
            case 5: {
                return (byte)this.buf.getInt();
            }
            case 9: {
                return (byte)this.buf.getDouble();
            }
            case 16: 
            case 17: 
            case 18: {
                return this.buf.get();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public ByteBuffer readToByteBuffer(ByteBuffer dest, int elements, ByteStorageSupport<?> storage) throws IOException {
        int bytesAllocated = storage.getBytesAllocated();
        int size = elements * storage.getBytesAllocated();
        if (MatDataTypes.sizeOf(this.type) == bytesAllocated && this.buf.order().equals(dest.order())) {
            int bufMaxSize = 1024;
            int bufSize = Math.min(this.buf.remaining(), bufMaxSize);
            int bufPos = this.buf.position();
            byte[] tmp = new byte[bufSize];
            while (dest.remaining() > 0) {
                int length = Math.min(dest.remaining(), tmp.length);
                this.buf.get(tmp, 0, length);
                dest.put(tmp, 0, length);
            }
            this.buf.position(bufPos + size);
        } else {
            Class<?> clazz = storage.getStorageClazz();
            while (dest.remaining() > 0) {
                if (clazz.equals(Double.class)) {
                    dest.putDouble(this.readDouble());
                    continue;
                }
                if (clazz.equals(Byte.class)) {
                    dest.put(this.readByte());
                    continue;
                }
                if (clazz.equals(Integer.class)) {
                    dest.putInt(this.readInt());
                    continue;
                }
                if (clazz.equals(Long.class)) {
                    dest.putLong(this.readLong());
                    continue;
                }
                if (clazz.equals(Float.class)) {
                    dest.putFloat(this.readFloat());
                    continue;
                }
                if (clazz.equals(Short.class)) {
                    dest.putShort(this.readShort());
                    continue;
                }
                throw new RuntimeException("Not supported buffer reader for " + clazz);
            }
        }
        dest.rewind();
        return dest;
    }

    private float readFloat() {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt();
            }
            case 5: {
                return this.buf.getInt();
            }
            case 7: {
                return this.buf.getFloat();
            }
            case 9: {
                return (float)this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    private short readShort() {
        switch (this.type) {
            case 2: {
                return (short)(this.buf.get() & 0xFF);
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return (short)(this.buf.getShort() & 0xFFFF);
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return (short)this.buf.getInt();
            }
            case 5: {
                return (short)this.buf.getInt();
            }
            case 13: {
                return (short)this.buf.getLong();
            }
            case 12: {
                return (short)this.buf.getLong();
            }
            case 9: {
                return (short)this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    private long readLong() {
        switch (this.type) {
            case 2: {
                return this.buf.get() & 0xFF;
            }
            case 1: {
                return this.buf.get();
            }
            case 4: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 3: {
                return this.buf.getShort();
            }
            case 6: {
                return this.buf.getInt();
            }
            case 5: {
                return this.buf.getInt();
            }
            case 13: {
                return this.buf.getLong();
            }
            case 12: {
                return this.buf.getLong();
            }
            case 9: {
                return (long)this.buf.getDouble();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + this.type);
    }

    public void skip(int padding) {
        this.buf.position(this.buf.position() + padding);
    }
}

