/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.logging.Logger;
import matlabcontrol.MatlabConnectionException;

class Configuration {
    private static Logger sLog = Logger.getLogger(Configuration.class.getName());

    private Configuration() {
    }

    static boolean isOSX() {
        return Configuration.getOperatingSystem().startsWith("Mac OS X");
    }

    static boolean isWindows() {
        return Configuration.getOperatingSystem().startsWith("Windows");
    }

    static boolean isLinux() {
        return Configuration.getOperatingSystem().startsWith("Linux");
    }

    static String getOperatingSystem() {
        return System.getProperty("os.name");
    }

    static String getMatlabLocation() throws MatlabConnectionException {
        String matlabLoc;
        if (Configuration.isOSX()) {
            matlabLoc = Configuration.getOSXMatlabLocation();
        } else if (Configuration.isWindows() || Configuration.isLinux()) {
            matlabLoc = "matlab";
        } else {
            throw new MatlabConnectionException("MATLAB's location or alias can only be determined for OS X, Windows, & Linux. For this operating system the location or alias must be specified explicitly.");
        }
        return matlabLoc;
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="OS X is very predictable")
    private static String getOSXMatlabLocation() throws MatlabConnectionException {
        String matlabName = null;
        String[] files = new File("/Applications/").list();
        if (files != null) {
            for (String fileName : files) {
                if (!fileName.startsWith("MATLAB")) continue;
                matlabName = fileName;
            }
        }
        if (matlabName == null) {
            throw new MatlabConnectionException("No installation of MATLAB on OS X can be found");
        }
        String matlabLocation = "/Applications/" + matlabName + "/bin/matlab";
        if (!new File(matlabLocation).exists()) {
            throw new MatlabConnectionException("An installation of MATLAB on OS X was found but the main executable file was not found in the anticipated location: " + matlabLocation);
        }
        return matlabLocation;
    }

    static String getClassPathAsRMICodebase() throws MatlabConnectionException {
        String entry = "";
        try {
            StringBuilder codebaseBuilder = new StringBuilder();
            String[] paths = System.getProperty("java.class.path", "").split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                File f = new File(paths[i]);
                if (f.exists() && !f.isDirectory()) {
                    entry = new File(paths[i]).getCanonicalFile().toURI().toURL().getPath();
                    codebaseBuilder.append("file://");
                    codebaseBuilder.append(entry);
                }
                if (i == paths.length - 1) continue;
                codebaseBuilder.append(" ");
            }
            return codebaseBuilder.toString();
        }
        catch (IOException e) {
            sLog.severe("Unable to resolve classpath entry: " + entry);
            throw new MatlabConnectionException("Unable to resolve classpath entry", e);
        }
    }

    static String[] getClassPathAsCanonicalPaths() throws MatlabConnectionException {
        try {
            String[] paths = System.getProperty("java.class.path", "").split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                File f = new File(paths[i]);
                if (f.exists()) {
                    paths[i] = f.getCanonicalPath();
                    continue;
                }
                sLog.severe("Classpath entry " + paths[i] + " not found. Adding absolute path instead.");
                paths[i] = new File(paths[i]).getAbsolutePath();
            }
            return paths;
        }
        catch (IOException e) {
            throw new MatlabConnectionException("Unable to resolve classpath entry", e);
        }
    }

    static String getSupportCodeLocation() throws MatlabConnectionException {
        ProtectionDomain domain = Configuration.class.getProtectionDomain();
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource != null) {
            URL url = codeSource.getLocation();
            if (url != null) {
                try {
                    File file = new File(url.getPath()).getCanonicalFile();
                    if (file.exists()) {
                        return file.getAbsolutePath();
                    }
                    file = new File(url.toURI()).getCanonicalFile();
                    if (file.exists()) {
                        return file.getAbsolutePath();
                    }
                    ClassLoader loader = Configuration.class.getClassLoader();
                    throw new MatlabConnectionException("Support code location was determined improperly. Location does not exist.\nLocation determined as: " + file.getAbsolutePath() + "\nFile: " + file + "\nURL Location: " + url + "\nCode Source: " + codeSource + "\nProtection Domain: " + domain + "\nClass Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()));
                }
                catch (IOException e) {
                    ClassLoader loader = Configuration.class.getClassLoader();
                    throw new MatlabConnectionException("Support code location could not be determined. Could not resolve canonical path.\nURL Location: " + url + "\nCode Source: " + codeSource + "\nProtection Domain: " + domain + "\nClass Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()), e);
                }
                catch (URISyntaxException e) {
                    ClassLoader loader = Configuration.class.getClassLoader();
                    throw new MatlabConnectionException("Support code location could not be determined. Could not convert URI location to file path.\nURL Location: " + url + "\nCode Source: " + codeSource + "\nProtection Domain: " + domain + "\nClass Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()), e);
                }
            }
            ClassLoader loader = Configuration.class.getClassLoader();
            throw new MatlabConnectionException("Support code location could not be determined. Could not get URL from CodeSource.\nCode Source: " + codeSource + "\nProtection Domain: " + domain + "\nClass Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()));
        }
        ClassLoader loader = Configuration.class.getClassLoader();
        throw new MatlabConnectionException("Support code location could not be determined. Could not get CodeSource from ProtectionDomain.\nProtection Domain: " + domain + "\nClass Loader: " + loader + (loader == null ? "" : "\nClass Loader Class: " + loader.getClass()));
    }

    static boolean isRunningInsideMatlab() {
        boolean available;
        try {
            Class<?> matlabClass = Class.forName("com.mathworks.jmi.Matlab");
            Method isAvailableMethod = matlabClass.getMethod("isMatlabAvailable", new Class[0]);
            available = (Boolean)isAvailableMethod.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            available = false;
        }
        return available;
    }
}

