/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.ThrowableWrapper;

class JMIWrapper {
    private static final MatlabThreadOperations THREAD_OPERATIONS = new MatlabThreadOperations();
    private static final EventQueue EVENT_QUEUE = Toolkit.getDefaultToolkit().getSystemEventQueue();
    private static final Method EVENT_QUEUE_DISPATCH_METHOD;

    private JMIWrapper() {
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="False positive.")
    static void exit() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Matlab.mtFevalConsoleOutput("exit", null, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };
        if (NativeMatlab.nativeIsMatlabThread()) {
            runnable.run();
        } else {
            Matlab.whenMatlabIdle(runnable);
        }
    }

    static void setVariable(final String variableName, final Object value) throws MatlabInvocationException {
        JMIWrapper.invokeAndWait(new MatlabProxy.MatlabThreadCallable<Void>(){

            @Override
            public Void call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
                proxy.setVariable(variableName, value);
                return null;
            }
        });
    }

    static Object getVariable(final String variableName) throws MatlabInvocationException {
        return JMIWrapper.invokeAndWait(new MatlabProxy.MatlabThreadCallable<Object>(){

            @Override
            public Object call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
                return proxy.getVariable(variableName);
            }
        });
    }

    static void eval(final String command) throws MatlabInvocationException {
        JMIWrapper.invokeAndWait(new MatlabProxy.MatlabThreadCallable<Void>(){

            @Override
            public Void call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
                proxy.eval(command);
                return null;
            }
        });
    }

    static Object[] returningEval(final String command, final int nargout) throws MatlabInvocationException {
        return JMIWrapper.invokeAndWait(new MatlabProxy.MatlabThreadCallable<Object[]>(){

            @Override
            public Object[] call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
                return proxy.returningEval(command, nargout);
            }
        });
    }

    static void feval(final String functionName, final Object ... args) throws MatlabInvocationException {
        JMIWrapper.invokeAndWait(new MatlabProxy.MatlabThreadCallable<Void>(){

            @Override
            public Void call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
                proxy.feval(functionName, args);
                return null;
            }
        });
    }

    static Object[] returningFeval(final String functionName, final int nargout, final Object ... args) throws MatlabInvocationException {
        return JMIWrapper.invokeAndWait(new MatlabProxy.MatlabThreadCallable<Object[]>(){

            @Override
            public Object[] call(MatlabProxy.MatlabThreadProxy proxy) throws MatlabInvocationException {
                return proxy.returningFeval(functionName, nargout, args);
            }
        });
    }

    static <T> T invokeAndWait(final MatlabProxy.MatlabThreadCallable<T> callable) throws MatlabInvocationException {
        T result;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                result = callable.call(THREAD_OPERATIONS);
            }
            catch (RuntimeException e) {
                ThrowableWrapper cause = new ThrowableWrapper(e);
                throw MatlabInvocationException.Reason.RUNTIME_EXCEPTION.asException(cause);
            }
        }
        if (EventQueue.isDispatchThread()) {
            final AtomicReference returnRef = new AtomicReference();
            Matlab.whenMatlabIdle(new Runnable(){

                @Override
                public void run() {
                    MatlabReturn matlabReturn;
                    try {
                        matlabReturn = new MatlabReturn(callable.call(THREAD_OPERATIONS));
                    }
                    catch (MatlabInvocationException e) {
                        matlabReturn = new MatlabReturn(e);
                    }
                    catch (RuntimeException e) {
                        ThrowableWrapper cause = new ThrowableWrapper(e);
                        MatlabInvocationException userCausedException = MatlabInvocationException.Reason.RUNTIME_EXCEPTION.asException(cause);
                        matlabReturn = new MatlabReturn(userCausedException);
                    }
                    returnRef.set(matlabReturn);
                }
            });
            try {
                while (returnRef.get() == null) {
                    if (EVENT_QUEUE.peekEvent() == null) continue;
                    EVENT_QUEUE_DISPATCH_METHOD.invoke((Object)EVENT_QUEUE, EVENT_QUEUE.getNextEvent());
                }
            }
            catch (InterruptedException e) {
                throw MatlabInvocationException.Reason.EVENT_DISPATCH_THREAD.asException(e);
            }
            catch (IllegalAccessException e) {
                throw MatlabInvocationException.Reason.EVENT_DISPATCH_THREAD.asException(e);
            }
            catch (InvocationTargetException e) {
                throw MatlabInvocationException.Reason.EVENT_DISPATCH_THREAD.asException(e);
            }
            MatlabReturn matlabReturn = (MatlabReturn)returnRef.get();
            if (matlabReturn.exception != null) {
                throw matlabReturn.exception;
            }
            result = matlabReturn.data;
        } else {
            final ArrayBlockingQueue returnQueue = new ArrayBlockingQueue(1);
            Matlab.whenMatlabIdle(new Runnable(){

                @Override
                public void run() {
                    MatlabReturn matlabReturn;
                    try {
                        matlabReturn = new MatlabReturn(callable.call(THREAD_OPERATIONS));
                    }
                    catch (MatlabInvocationException e) {
                        matlabReturn = new MatlabReturn(e);
                    }
                    catch (RuntimeException e) {
                        ThrowableWrapper cause = new ThrowableWrapper(e);
                        MatlabInvocationException userCausedException = MatlabInvocationException.Reason.RUNTIME_EXCEPTION.asException(cause);
                        matlabReturn = new MatlabReturn(userCausedException);
                    }
                    returnQueue.add(matlabReturn);
                }
            });
            try {
                MatlabReturn matlabReturn = (MatlabReturn)returnQueue.take();
                if (matlabReturn.exception != null) {
                    throw matlabReturn.exception;
                }
                result = matlabReturn.data;
            }
            catch (InterruptedException e) {
                throw MatlabInvocationException.Reason.INTERRRUPTED.asException(e);
            }
        }
        return result;
    }

    static {
        try {
            EVENT_QUEUE_DISPATCH_METHOD = EventQueue.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("java.awt.EventQueue's protected void dispatchEvent(java.awt.AWTEvent) method could not be found", e);
        }
        EVENT_QUEUE_DISPATCH_METHOD.setAccessible(true);
    }

    private static class MatlabThreadOperations
    implements MatlabProxy.MatlabThreadProxy {
        private MatlabThreadOperations() {
        }

        @Override
        public void setVariable(String variableName, Object value) throws MatlabInvocationException {
            this.returningFeval("assignin", 0, "base", variableName, value);
        }

        @Override
        public Object getVariable(String variableName) throws MatlabInvocationException {
            return this.returningFeval("evalin", 1, "base", variableName)[0];
        }

        @Override
        public void eval(String command) throws MatlabInvocationException {
            this.returningFeval("evalin", 0, "base", command);
        }

        @Override
        public Object[] returningEval(String command, int nargout) throws MatlabInvocationException {
            return this.returningFeval("evalin", nargout, "base", command);
        }

        @Override
        public void feval(String functionName, Object ... args) throws MatlabInvocationException {
            this.returningFeval(functionName, 0, args);
        }

        @Override
        public Object[] returningFeval(String functionName, int nargout, Object ... args) throws MatlabInvocationException {
            if (args != null && args.length == 0) {
                args = null;
            }
            try {
                Object[] resultArray;
                Object matlabResult = Matlab.mtFevalConsoleOutput(functionName, args, nargout);
                if (nargout == 0) {
                    resultArray = new Object[]{};
                } else if (nargout == 1) {
                    resultArray = new Object[]{matlabResult};
                } else {
                    if (matlabResult == null) {
                        String errorMsg = "Expected " + nargout + " return arguments, instead null was returned";
                        throw MatlabInvocationException.Reason.NARGOUT_MISMATCH.asException(errorMsg);
                    }
                    if (!matlabResult.getClass().equals(Object[].class)) {
                        String errorMsg = "Expected " + nargout + " return arguments, instead 1 argument was returned";
                        throw MatlabInvocationException.Reason.NARGOUT_MISMATCH.asException(errorMsg);
                    }
                    resultArray = (Object[])matlabResult;
                    if (nargout != resultArray.length) {
                        String errorMsg = "Expected " + nargout + " return arguments, instead " + resultArray.length + (resultArray.length == 1 ? " argument was" : " arguments were") + " returned";
                        throw MatlabInvocationException.Reason.NARGOUT_MISMATCH.asException(errorMsg);
                    }
                }
                return resultArray;
            }
            catch (Exception e) {
                throw MatlabInvocationException.Reason.INTERNAL_EXCEPTION.asException(new ThrowableWrapper(e));
            }
        }
    }

    private static class MatlabReturn<T> {
        final T data;
        final MatlabInvocationException exception;

        MatlabReturn(T value) {
            this.data = value;
            this.exception = null;
        }

        MatlabReturn(MatlabInvocationException exception) {
            this.data = null;
            this.exception = exception;
        }
    }
}

