/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.util.concurrent.CopyOnWriteArrayList;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabOperations;

public abstract class MatlabProxy
implements MatlabOperations {
    private final Identifier _id;
    private final boolean _existingSession;
    private final CopyOnWriteArrayList<DisconnectionListener> _listeners;

    MatlabProxy(Identifier id, boolean existingSession) {
        this._id = id;
        this._existingSession = existingSession;
        this._listeners = new CopyOnWriteArrayList();
    }

    public Identifier getIdentifier() {
        return this._id;
    }

    public boolean isExistingSession() {
        return this._existingSession;
    }

    public String toString() {
        return "[" + this.getClass().getName() + " identifier=" + this.getIdentifier() + ", connected=" + this.isConnected() + ", insideMatlab=" + this.isRunningInsideMatlab() + ", existingSession=" + this.isExistingSession() + "]";
    }

    public void addDisconnectionListener(DisconnectionListener listener) {
        this._listeners.add(listener);
    }

    public void removeDisconnectionListener(DisconnectionListener listener) {
        this._listeners.remove(listener);
    }

    void notifyDisconnectionListeners() {
        for (DisconnectionListener listener : this._listeners) {
            listener.proxyDisconnected(this);
        }
    }

    public abstract boolean isRunningInsideMatlab();

    public abstract boolean isConnected();

    public abstract boolean disconnect();

    public abstract void exit() throws MatlabInvocationException;

    public abstract <T> T invokeAndWait(MatlabThreadCallable<T> var1) throws MatlabInvocationException;

    public static interface Identifier {
        public boolean equals(Object var1);

        public int hashCode();
    }

    public static interface DisconnectionListener {
        public void proxyDisconnected(MatlabProxy var1);
    }

    public static interface MatlabThreadProxy
    extends MatlabOperations {
    }

    public static interface MatlabThreadCallable<T> {
        public T call(MatlabThreadProxy var1) throws MatlabInvocationException;
    }
}

