/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.io.File;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import matlabcontrol.MatlabProxyFactory;

public class MatlabProxyFactoryOptions {
    private final String _matlabLocation;
    private final File _startingDirectory;
    private final boolean _hidden;
    private final boolean _usePreviouslyControlled;
    private final boolean _osgiClassloaderFriendly;
    private final MatlabProxyFactory.CopyPasteCallback _copyPasteCallback;
    private final long _proxyTimeout;
    private final String _logFile;
    private final Integer _jdbPort;
    private final String _licenseFile;
    private final boolean _useSingleCompThread;
    private final int _port;
    private final Writer _outputWriter;
    private final Writer _errorWriter;
    private final Map<String, String> _matlabEnvironment;

    private MatlabProxyFactoryOptions(Builder options) {
        this._matlabLocation = options._matlabLocation;
        this._startingDirectory = options._startingDirectory;
        this._hidden = options._hidden;
        this._usePreviouslyControlled = options._usePreviouslyControlled;
        this._osgiClassloaderFriendly = options._osgiClassloaderFriendly;
        this._copyPasteCallback = options._copyPasteCallback;
        this._proxyTimeout = options._proxyTimeout.get();
        this._logFile = options._logFile;
        this._jdbPort = options._jdbPort;
        this._licenseFile = options._licenseFile;
        this._useSingleCompThread = options._useSingleCompThread;
        this._port = options._port;
        this._outputWriter = options._outputWriter;
        this._errorWriter = options._errorWriter;
        this._matlabEnvironment = options._matlabEnvironment;
    }

    String getMatlabLocation() {
        return this._matlabLocation;
    }

    File getStartingDirectory() {
        return this._startingDirectory;
    }

    boolean getHidden() {
        return this._hidden;
    }

    boolean getOsgiClassloaderFriendly() {
        return this._osgiClassloaderFriendly;
    }

    boolean getUsePreviouslyControlledSession() {
        return this._usePreviouslyControlled;
    }

    MatlabProxyFactory.CopyPasteCallback getCopyPasteCallback() {
        return this._copyPasteCallback;
    }

    long getProxyTimeout() {
        return this._proxyTimeout;
    }

    String getLogFile() {
        return this._logFile;
    }

    Integer getJavaDebugger() {
        return this._jdbPort;
    }

    String getLicenseFile() {
        return this._licenseFile;
    }

    boolean getUseSingleComputationalThread() {
        return this._useSingleCompThread;
    }

    int getPort() {
        return this._port;
    }

    Writer getOutputWriter() {
        return this._outputWriter;
    }

    Writer getErrorWriter() {
        return this._errorWriter;
    }

    Map<String, String> getMatlabEnvironment() {
        return this._matlabEnvironment;
    }

    public static class Builder {
        private volatile String _matlabLocation = null;
        private volatile File _startingDirectory = null;
        private volatile boolean _hidden = false;
        private volatile boolean _usePreviouslyControlled = false;
        private volatile boolean _osgiClassloaderFriendly = false;
        private volatile MatlabProxyFactory.CopyPasteCallback _copyPasteCallback = null;
        private volatile String _logFile = null;
        private volatile Integer _jdbPort = null;
        private volatile String _licenseFile = null;
        private volatile boolean _useSingleCompThread = false;
        private volatile int _port = 2100;
        private volatile Writer _outputWriter = null;
        private volatile Writer _errorWriter = null;
        private volatile Map<String, String> _matlabEnvironment = null;
        private final AtomicLong _proxyTimeout = new AtomicLong(180000L);

        public final Builder setMatlabLocation(String matlabLocation) {
            this._matlabLocation = matlabLocation;
            return this;
        }

        public final Builder setMatlabStartingDirectory(File dir) {
            if (dir == null) {
                throw new NullPointerException("dir may not be null");
            }
            if (!dir.exists()) {
                throw new IllegalArgumentException("dir specifies a directory that does not exist");
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("dir does not specify a directory");
            }
            this._startingDirectory = dir;
            return this;
        }

        public final Builder setHidden(boolean hidden) {
            this._hidden = hidden;
            return this;
        }

        public final Builder setLogFile(String logFile) {
            this._logFile = logFile;
            return this;
        }

        public final Builder setJavaDebugger(int portnumber) {
            if (portnumber < 0 || portnumber > 65535) {
                throw new IllegalArgumentException("port number [" + portnumber + "] must be in the range 0-65535");
            }
            this._jdbPort = portnumber;
            return this;
        }

        public final Builder setLicenseFile(String licenseFile) {
            this._licenseFile = licenseFile;
            return this;
        }

        public final Builder setUsePreviouslyControlledSession(boolean usePreviouslyControlled) {
            this._usePreviouslyControlled = usePreviouslyControlled;
            return this;
        }

        public final Builder setOSGiClassloaderFriendly(boolean osgiClassloaderFriendly) {
            this._osgiClassloaderFriendly = osgiClassloaderFriendly;
            return this;
        }

        public final Builder setCopyPasteCallback(MatlabProxyFactory.CopyPasteCallback copyPasteCallback) {
            this._copyPasteCallback = copyPasteCallback;
            return this;
        }

        public final Builder setProxyTimeout(long timeout) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout [" + timeout + "] may not be negative");
            }
            this._proxyTimeout.set(timeout);
            return this;
        }

        public final Builder setUseSingleComputationalThread(boolean useSingleCompThread) {
            this._useSingleCompThread = useSingleCompThread;
            return this;
        }

        public final Builder setPort(int port) {
            if (port < 0) {
                throw new IllegalArgumentException("port [" + port + "] may not be negative");
            }
            this._port = port;
            return this;
        }

        public final Builder setOutputWriter(Writer outputWriter) {
            this._outputWriter = outputWriter;
            return this;
        }

        public final Builder setErrorWriter(Writer errorWriter) {
            this._errorWriter = errorWriter;
            return this;
        }

        public final Builder setMatlabEnvironment(Map<String, String> matlabEnvironment) {
            this._matlabEnvironment = matlabEnvironment;
            return this;
        }

        public final MatlabProxyFactoryOptions build() {
            return new MatlabProxyFactoryOptions(this);
        }
    }
}

