/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.demo;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ArrayPanel
extends JPanel {
    private static final int DOUBLE_INDEX = 0;
    private static final int STRING_INDEX = 1;
    private static final String[] OPTIONS = new String[2];
    public static final int NUM_ENTRIES = 3;
    private final JComboBox[] _optionBoxes;
    private final JTextField[] _entryFields;

    public ArrayPanel() {
        super(new GridLayout(3, 2));
        this.setBackground(Color.WHITE);
        this._optionBoxes = new JComboBox[3];
        this._entryFields = new JTextField[3];
        for (int i = 0; i < 3; ++i) {
            this._optionBoxes[i] = new JComboBox<String>(OPTIONS);
            this._entryFields[i] = new JTextField(8);
            this.add(this._optionBoxes[i]);
            this.add(this._entryFields[i]);
        }
    }

    public Object[] getArray() {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (int i = 0; i < 3; ++i) {
            if (this._entryFields[i].getText().isEmpty()) continue;
            if (this._optionBoxes[i].getSelectedIndex() == 0) {
                try {
                    entries.add(Double.parseDouble(this._entryFields[i].getText()));
                }
                catch (Exception e) {
                    entries.add(0);
                }
            }
            if (this._optionBoxes[i].getSelectedIndex() != 1) continue;
            entries.add(this._entryFields[i].getText());
        }
        return entries.toArray();
    }

    public Object getFirstEntry() {
        if (!this._entryFields[0].getText().isEmpty()) {
            if (this._optionBoxes[0].getSelectedIndex() == 0) {
                try {
                    return Double.parseDouble(this._entryFields[0].getText());
                }
                catch (Exception e) {
                    return 0;
                }
            }
            if (this._optionBoxes[0].getSelectedIndex() == 1) {
                return this._entryFields[0].getText();
            }
        }
        return null;
    }

    public void enableInputFields(int n) {
        for (int i = 0; i < 3; ++i) {
            this._optionBoxes[i].setEnabled(i < n);
            this._entryFields[i].setEnabled(i < n);
        }
    }

    static {
        ArrayPanel.OPTIONS[0] = "Double";
        ArrayPanel.OPTIONS[1] = "String";
    }
}

