/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.extensions;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MatlabNumericArray {
    private final double[] _realValues;
    private final double[] _imaginaryValues;
    private final int[] _lengths;
    private final DoubleArrayType<?> _arrayType;
    private final boolean _fromMatlab;
    private final boolean _isReal;

    MatlabNumericArray(double[] real, double[] imaginary, int[] lengths) {
        this._fromMatlab = true;
        this._realValues = real;
        this._imaginaryValues = imaginary;
        this._isReal = imaginary == null;
        this._lengths = lengths;
        this._arrayType = DoubleArrayType.getInstance(lengths.length);
    }

    public <T> MatlabNumericArray(DoubleArrayType<T> type, T real, T imaginary) {
        if (type == null) {
            throw new NullPointerException("The type of the arrays may not be null.");
        }
        if (real == null) {
            throw new NullPointerException("Real array may not be null.");
        }
        this._fromMatlab = false;
        this._isReal = imaginary == null;
        this._arrayType = type;
        this._lengths = new int[type.getDimensions()];
        int[] realLengths = MatlabNumericArray.computeBoundingLengths(real);
        for (int i = 0; i < realLengths.length; ++i) {
            this._lengths[i] = Math.max(this._lengths[i], realLengths[i]);
        }
        if (imaginary != null) {
            int[] imaginaryLengths = MatlabNumericArray.computeBoundingLengths(imaginary);
            for (int i = 0; i < imaginaryLengths.length; ++i) {
                this._lengths[i] = Math.max(this._lengths[i], imaginaryLengths[i]);
            }
        }
        this._realValues = MatlabNumericArray.linearize(real, this._lengths);
        this._imaginaryValues = (double[])(imaginary != null ? MatlabNumericArray.linearize(imaginary, this._lengths) : null);
    }

    public MatlabNumericArray(double[][] real, double[][] imaginary) {
        this(DoubleArrayType.DIM_2, real, imaginary);
    }

    public MatlabNumericArray(double[][][] real, double[][][] imaginary) {
        this(DoubleArrayType.DIM_3, real, imaginary);
    }

    public MatlabNumericArray(double[][][][] real, double[][][][] imaginary) {
        this(DoubleArrayType.DIM_4, real, imaginary);
    }

    private static int getTotalSize(int[] lengths) {
        int size = 0;
        for (int length : lengths) {
            if (size == 0) {
                size = length;
                continue;
            }
            if (length == 0) continue;
            size *= length;
        }
        return size;
    }

    public double getRealValue(int linearIndex) {
        return this._realValues[linearIndex];
    }

    public double getImaginaryValue(int linearIndex) {
        if (this._isReal) {
            throw new IllegalStateException("array is real");
        }
        return this._imaginaryValues[linearIndex];
    }

    public double getRealValue(int ... indices) {
        return this.getValue(this._realValues, indices);
    }

    public double getImaginaryValue(int ... indices) {
        if (this._isReal) {
            throw new IllegalStateException("array is real");
        }
        return this.getValue(this._imaginaryValues, indices);
    }

    private double getValue(double[] values, int ... indices) throws ArrayDimensionException, ArrayIndexOutOfBoundsException {
        if (indices.length == this.getDimensions()) {
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] < this._lengths[i]) continue;
                throw new IndexOutOfBoundsException("[" + indices[i] + "] is out of bounds for dimension " + i + " where the length is " + this._lengths[i]);
            }
        } else {
            throw new ArrayDimensionException(this._arrayType.getDimensions(), indices.length);
        }
        double value = values[MatlabNumericArray.multidimensionalIndicesToLinearIndex(this._lengths, indices)];
        return value;
    }

    public int getDimensions() {
        return this._arrayType.getDimensions();
    }

    public int[] getLengths() {
        int[] lengthsCopy = new int[this._lengths.length];
        System.arraycopy(this._lengths, 0, lengthsCopy, 0, this._lengths.length);
        return lengthsCopy;
    }

    public int getLength() {
        return this._realValues.length;
    }

    private <T> T getAsJavaArray(DoubleArrayType<T> type, double[] values) {
        if (type.getDimensions() != this._arrayType.getDimensions()) {
            throw new ArrayDimensionException(this._arrayType.getDimensions(), type.getDimensions());
        }
        return MatlabNumericArray.multidimensionalize(values, ((DoubleArrayType)type)._arrayClass, this._lengths);
    }

    public <T> T getRealArray(DoubleArrayType<T> type) {
        return this.getAsJavaArray(type, this._realValues);
    }

    public double[][] getRealArray2D() {
        return this.getRealArray(DoubleArrayType.DIM_2);
    }

    public double[][][] getRealArray3D() {
        return this.getRealArray(DoubleArrayType.DIM_3);
    }

    public double[][][][] getRealArray4D() {
        return this.getRealArray(DoubleArrayType.DIM_4);
    }

    public <T> T getImaginaryArray(DoubleArrayType<T> type) {
        if (this._isReal) {
            throw new IllegalStateException("array is real");
        }
        return this.getAsJavaArray(type, this._imaginaryValues);
    }

    public double[][] getImaginaryArray2D() {
        return this.getImaginaryArray(DoubleArrayType.DIM_2);
    }

    public double[][][] getImaginaryArray3D() {
        return this.getImaginaryArray(DoubleArrayType.DIM_3);
    }

    public double[][][][] getImaginaryArray4D() {
        return this.getImaginaryArray(DoubleArrayType.DIM_4);
    }

    public boolean isReal() {
        return this._isReal;
    }

    double[] getRealLinearArray() {
        return this._realValues;
    }

    double[] getImaginaryLinearArray() {
        return this._imaginaryValues;
    }

    public String toString() {
        return "[" + this.getClass() + " dimensions=" + this.getDimensions() + ", linearLength=" + this.getLength() + ", lengths=" + Arrays.toString(this._lengths) + ", fromMATLAB=" + this._fromMatlab + "]";
    }

    private static int multidimensionalIndicesToLinearIndex(int[] lengths, int[] indices) {
        if (lengths.length != indices.length) {
            throw new IllegalArgumentException("There must be an equal number of lengths [" + lengths.length + "] and indices [" + indices.length + "]");
        }
        int linearIndex = 0;
        int accumSize = 1;
        for (int i = 0; i < lengths.length; ++i) {
            linearIndex += accumSize * indices[i];
            accumSize *= lengths[i];
        }
        return linearIndex;
    }

    private static <T> T multidimensionalize(double[] linearArray, Class<T> outputArrayType, int[] lengths) {
        return MatlabNumericArray.multidimensionalize_internal(linearArray, outputArrayType, lengths, 0, new int[0]);
    }

    private static <T> T multidimensionalize_internal(double[] linearArray, Class<T> outputArrayType, int[] lengths, int indexIntoLengths, int[] currIndices) {
        Class<?> arrayType = outputArrayType.getComponentType();
        int arrayLength = lengths[indexIntoLengths];
        Object array = Array.newInstance(arrayType, arrayLength);
        if (arrayType.isArray()) {
            if (arrayType.equals(double[].class)) {
                int[] primitiveArrayIndices = new int[currIndices.length + 2];
                System.arraycopy(currIndices, 0, primitiveArrayIndices, 0, currIndices.length);
                for (int i = 0; i < arrayLength; ++i) {
                    primitiveArrayIndices[primitiveArrayIndices.length - 2] = i;
                    double[] primitiveArray = new double[lengths[lengths.length - 1]];
                    for (int j = 0; j < primitiveArray.length; ++j) {
                        primitiveArrayIndices[primitiveArrayIndices.length - 1] = j;
                        int linearIndex = MatlabNumericArray.multidimensionalIndicesToLinearIndex(lengths, primitiveArrayIndices);
                        primitiveArray[j] = linearArray[linearIndex];
                    }
                    Array.set(array, i, primitiveArray);
                }
            } else {
                for (int i = 0; i < arrayLength; ++i) {
                    int[] nextIndices = new int[currIndices.length + 1];
                    System.arraycopy(currIndices, 0, nextIndices, 0, currIndices.length);
                    nextIndices[nextIndices.length - 1] = i;
                    Object innerArray = MatlabNumericArray.multidimensionalize_internal(linearArray, arrayType, lengths, indexIntoLengths + 1, nextIndices);
                    Array.set(array, i, innerArray);
                }
            }
        } else {
            System.arraycopy(linearArray, 0, array, 0, arrayLength);
        }
        return (T)array;
    }

    private static int[] computeBoundingLengths(Object array) {
        int arrayLength;
        DoubleArrayType<?> type = DoubleArrayType.getInstanceUnsafe(array.getClass());
        int[] maxLengths = new int[type.getDimensions()];
        maxLengths[0] = arrayLength = Array.getLength(array);
        if (!array.getClass().getComponentType().equals(Double.TYPE)) {
            for (int i = 0; i < arrayLength; ++i) {
                int[] childLengths = MatlabNumericArray.computeBoundingLengths(Array.get(array, i));
                for (int j = 0; j < childLengths.length; ++j) {
                    maxLengths[j + 1] = Math.max(maxLengths[j + 1], childLengths[j]);
                }
            }
        }
        return maxLengths;
    }

    private static double[] linearize(Object array, int[] lengths) {
        double[] linearArray = new double[MatlabNumericArray.getTotalSize(lengths)];
        MatlabNumericArray.linearize_internal(linearArray, array, lengths, new int[0]);
        return linearArray;
    }

    private static void linearize_internal(double[] linearArray, Object array, int[] lengths, int[] currIndices) {
        if (array.getClass().equals(double[].class)) {
            int[] doubleArrayIndices = new int[currIndices.length + 1];
            System.arraycopy(currIndices, 0, doubleArrayIndices, 0, currIndices.length);
            double[] doubleArray = (double[])array;
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArrayIndices[doubleArrayIndices.length - 1] = i;
                int linearIndex = MatlabNumericArray.multidimensionalIndicesToLinearIndex(lengths, doubleArrayIndices);
                linearArray[linearIndex] = doubleArray[i];
            }
        } else {
            int arrayLength = Array.getLength(array);
            for (int i = 0; i < arrayLength; ++i) {
                int[] nextIndices = new int[currIndices.length + 1];
                System.arraycopy(currIndices, 0, nextIndices, 0, currIndices.length);
                nextIndices[nextIndices.length - 1] = i;
                MatlabNumericArray.linearize_internal(linearArray, Array.get(array, i), lengths, nextIndices);
            }
        }
    }

    public static final class DoubleArrayType<T> {
        private static final Map<Class<?>, DoubleArrayType> CLASS_TO_ARRAY_TYPE = new ConcurrentHashMap();
        public static final DoubleArrayType<double[][]> DIM_2 = DoubleArrayType.getInstance(double[][].class);
        public static final DoubleArrayType<double[][][]> DIM_3 = DoubleArrayType.getInstance(double[][][].class);
        public static final DoubleArrayType<double[][][][]> DIM_4 = DoubleArrayType.getInstance(double[][][][].class);
        public static final DoubleArrayType<double[][][][][]> DIM_5 = DoubleArrayType.getInstance(double[][][][][].class);
        public static final DoubleArrayType<double[][][][][][]> DIM_6 = DoubleArrayType.getInstance(double[][][][][][].class);
        public static final DoubleArrayType<double[][][][][][][]> DIM_7 = DoubleArrayType.getInstance(double[][][][][][][].class);
        public static final DoubleArrayType<double[][][][][][][][]> DIM_8 = DoubleArrayType.getInstance(double[][][][][][][][].class);
        public static final DoubleArrayType<double[][][][][][][][][]> DIM_9 = DoubleArrayType.getInstance(double[][][][][][][][][].class);
        private final Class<T> _arrayClass;
        private final int _numDimensions;

        private DoubleArrayType(Class<T> arrayClass) {
            if (!DoubleArrayType.isDoubleArrayType(arrayClass)) {
                throw new IllegalArgumentException(arrayClass + " does not hold doubles");
            }
            this._arrayClass = arrayClass;
            this._numDimensions = DoubleArrayType.getNumberOfDimensions(arrayClass);
        }

        public static <T> DoubleArrayType<T> getInstance(Class<T> arrayType) {
            if (arrayType.equals(double[].class)) {
                throw new IllegalArgumentException(arrayType + " not supported, must be 2 or more dimensions");
            }
            return DoubleArrayType.getInstanceUnsafe(arrayType);
        }

        static <T> DoubleArrayType<T> getInstanceUnsafe(Class<T> arrayType) {
            if (!CLASS_TO_ARRAY_TYPE.containsKey(arrayType)) {
                DoubleArrayType<T> type = new DoubleArrayType<T>(arrayType);
                CLASS_TO_ARRAY_TYPE.put(arrayType, type);
            }
            return CLASS_TO_ARRAY_TYPE.get(arrayType);
        }

        static DoubleArrayType<?> getInstance(int dimensions) {
            DoubleArrayType<?> type;
            StringBuilder className = new StringBuilder(1 + dimensions);
            for (int i = 0; i < dimensions; ++i) {
                className.append('[');
            }
            className.append('D');
            try {
                type = DoubleArrayType.getInstanceUnsafe(Class.forName(className.toString()));
            }
            catch (ClassNotFoundException e) {
                type = null;
            }
            return type;
        }

        public int getDimensions() {
            return this._numDimensions;
        }

        public Class<T> getArrayClass() {
            return this._arrayClass;
        }

        private static boolean isDoubleArrayType(Class<?> type) {
            boolean isType;
            if (type.isArray()) {
                while (type.isArray()) {
                    type = type.getComponentType();
                }
                isType = type.equals(Double.TYPE);
            } else {
                isType = false;
            }
            return isType;
        }

        private static int getNumberOfDimensions(Class<?> type) {
            int numDim = 0;
            while (type.isArray()) {
                ++numDim;
                type = type.getComponentType();
            }
            return numDim;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " class=" + this._arrayClass + ", dimensions=" + this._numDimensions + "]";
        }
    }

    public static class ArrayDimensionException
    extends RuntimeException {
        private static final long serialVersionUID = 50176L;
        private final int _actualNumberOfDimensions;
        private final int _usedAsNumberOfDimensions;

        ArrayDimensionException(int actualNumDim, int usedAsNumDim) {
            super("Array has " + actualNumDim + " dimension(s), it cannot be used as if it had " + usedAsNumDim + " dimension(s).");
            this._actualNumberOfDimensions = actualNumDim;
            this._usedAsNumberOfDimensions = usedAsNumDim;
        }

        public int getActualNumberOfDimensions() {
            return this._actualNumberOfDimensions;
        }

        public int getUsedNumberOfDimensions() {
            return this._usedAsNumberOfDimensions;
        }
    }
}

